/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.view.controller;

import com.anf.autoupdate.UpdateParamsFactory;
import com.anf.autoupdate.model.UpdateParams;
import com.anf.autoupdate.text.Texts;
import com.anf.autoupdate.view.messages.Toast;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;

public class LaterController {
    @FXML
    private Label selectLabel;
    @FXML
    private JFXCheckBox laterCheck;
    @FXML
    private DatePicker datePicker;
    @FXML
    private Label timeLabel;
    @FXML
    private JFXComboBox<Integer> hour;
    @FXML
    private JFXComboBox<Integer> min;
    @FXML
    private JFXComboBox<LaterConfig> laterCombo;
    @FXML
    private JFXCheckBox sessionStartCheck;
    @FXML
    private JFXCheckBox neverCheck;
    @FXML
    private JFXCheckBox dateTimeCheck;
    @FXML
    private JFXButton okButton;
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    List<JFXCheckBox> checks = new ArrayList<JFXCheckBox>();
    private UpdateParams params;
    Date now = new Date();

    public void init(UpdateParams params) {
        this.params = params;
        this.selectLabel.setText(Texts.getText("select.when", new Object[0]));
        this.laterCheck.setText(Texts.getText("later", new Object[0]));
        this.dateTimeCheck.setText(Texts.getText("date.time", new Object[0]));
        this.sessionStartCheck.setText(Texts.getText("onsession.start", new Object[0]));
        this.neverCheck.setText(Texts.getText("never", new Object[0]));
        this.datePicker.setValue((Object)LocalDate.now());
        for (int h = 0; h < 24; ++h) {
            this.hour.getItems().add((Object)h);
        }
        for (int m = 0; m < 60; ++m) {
            this.min.getItems().add((Object)m);
        }
        this.selectors();
        this.dateTimeCheck.selectedProperty().addListener((src, old, newValue) -> {
            this.hour.setDisable(newValue == false);
            this.min.setDisable(newValue == false);
            this.datePicker.setDisable(newValue == false);
            if (newValue.booleanValue()) {
                this.onSelectedLaterConfig();
            }
        });
        this.laterCheck.selectedProperty().addListener((src, old, newValue) -> {
            if (newValue.booleanValue()) {
                this.onSelectedLaterConfig();
            }
        });
        this.laterCombo.getItems().addAll((Object[])new LaterConfig[]{new LaterConfig(Texts.getText("later.quarter.hour", new Object[0]), cal -> cal.add(12, 15)), new LaterConfig(Texts.getText("later.one.hour", new Object[0]), cal -> cal.add(10, 1)), new LaterConfig(Texts.getText("later.eight.hour", new Object[0]), cal -> cal.add(10, 8)), new LaterConfig(Texts.getText("later.one.day", new Object[0]), cal -> cal.add(6, 1))});
        this.laterCombo.getSelectionModel().select(2);
        this.onSelectedLaterConfig();
        this.laterCombo.setOnAction(e -> this.onSelectedLaterConfig());
        this.okButton.setOnAction(this::ok);
    }

    private void onSelectedLaterConfig() {
        LaterConfig later = (LaterConfig)this.laterCombo.getSelectionModel().getSelectedItem();
        if (later != null) {
            Calendar cal = later.getDate();
            this.datePicker.setValue((Object)LocalDate.of(cal.get(1), cal.get(2) + 1, cal.get(5)));
            this.hour.getSelectionModel().select(cal.get(11));
            this.min.getSelectionModel().select(cal.get(12));
        }
    }

    private void ok(ActionEvent e) {
        Properties conf = new Properties();
        String message = "";
        if (this.laterCheck.isSelected() || this.dateTimeCheck.isSelected()) {
            LocalDate ld = (LocalDate)this.datePicker.getValue();
            Calendar c = Calendar.getInstance();
            c.set(ld.getYear(), ld.getMonthValue() - 1, ld.getDayOfMonth(), (Integer)this.hour.getSelectionModel().getSelectedItem(), (Integer)this.min.getSelectionModel().getSelectedItem());
            Date date = c.getTime();
            if (date.before(this.now)) {
                Toast.show(Texts.getText("date.before", this.dateFormat.format(this.now)), (Control)this.okButton);
                return;
            }
            String format = this.dateFormat.format(date);
            conf.setProperty("next.update.date", format);
            conf.setProperty("next.update", "date");
            message = Texts.getText("message.next.update.date", format);
        } else if (this.sessionStartCheck.isSelected()) {
            conf.setProperty("next.update", "session-start");
            message = Texts.getText("message.next.update.session", new Object[0]);
        } else if (this.neverCheck.isSelected()) {
            conf.setProperty("next.update", "never");
            message = Texts.getText("message.next.update.never", new Object[0]);
        }
        try {
            UpdateParamsFactory.updateConfigFile(this.params.getConfigFile(), conf);
            Toast.show(message, (Control)this.okButton, () -> {
                Platform.exit();
                System.exit(0);
            });
        }
        catch (IOException e1) {
            Toast.show(Texts.getText("error", e1), (Control)this.okButton);
        }
    }

    private void selectors() {
        this.selector(this.laterCheck);
        this.selector(this.dateTimeCheck);
        this.selector(this.neverCheck);
        this.selector(this.sessionStartCheck);
        this.checks.add(this.laterCheck);
        this.checks.add(this.dateTimeCheck);
        this.checks.add(this.neverCheck);
        this.checks.add(this.sessionStartCheck);
    }

    private void selector(JFXCheckBox check) {
        check.selectedProperty().addListener(this.select(check));
    }

    private ChangeListener<Boolean> select(JFXCheckBox select) {
        return (arg0, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                for (JFXCheckBox check : this.checks) {
                    if (check == select) continue;
                    check.setSelected(false);
                }
            } else {
                int selected = 0;
                for (JFXCheckBox check : this.checks) {
                    if (!check.isSelected()) continue;
                    ++selected;
                }
                if (selected == 0) {
                    select.setSelected(true);
                }
            }
        };
    }

    class LaterConfig {
        private String text;
        private Consumer<Calendar> date;

        public LaterConfig(String text, Consumer<Calendar> date) {
            this.text = text;
            this.date = date;
        }

        public String toString() {
            return this.text;
        }

        public Calendar getDate() {
            Calendar cal = Calendar.getInstance();
            cal.setTime(LaterController.this.now);
            this.date.accept(cal);
            return cal;
        }
    }
}

