/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.services;

import com.anf.autoupdate.client.model.AppVersion;
import com.anf.autoupdate.client.model.NormalizeVersion;
import com.anf.autoupdate.model.UpdateParams;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface NextUpdateValidator {
    public static final Logger log = LogManager.getLogger(NextUpdateValidator.class);
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public static void validateNextUpdate(UpdateParams params, AppVersion lastVersion, boolean forced, boolean sessionInit) throws Exception {
        String nextUpdate;
        Properties conf = params.getConf();
        if (!forced && (nextUpdate = conf.getProperty("next.update")) != null) {
            switch (nextUpdate) {
                case "never": {
                    throw new Exception("ERR_NEVER_UPDATE");
                }
                case "date": {
                    String nextUpdateDate = conf.getProperty("next.update.date");
                    Date date = dateFormat.parse(nextUpdateDate);
                    if (!date.after(new Date())) break;
                    throw new Exception("ERR_NO_UPDATE_UNTIL_DATE:" + nextUpdateDate);
                }
                case "next-update": {
                    String skipVersion = conf.getProperty("next.update.skip");
                    if (NormalizeVersion.validate(lastVersion.getVersion(), skipVersion)) break;
                    throw new Exception("ERR_SKIP_VERSION:" + lastVersion.getVersion());
                }
                case "session-start": {
                    if (sessionInit) break;
                    throw new Exception("ERR_UPDATE_ON_SESSION_START");
                }
                case "always": {
                    break;
                }
                default: {
                    log.warn("Unexpected next.update value: {}", (Object)nextUpdate);
                }
            }
        }
    }
}

