/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileDigest {
    private static final Logger log = LogManager.getLogger(FileDigest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hash(File file) throws IOException, NoSuchAlgorithmException {
        long t1 = System.nanoTime();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            int bufferSize = 20480;
            byte[] buffer = new byte[bufferSize];
            int sizeRead = -1;
            try (FileInputStream in = new FileInputStream(file);){
                while ((sizeRead = in.read(buffer)) != -1) {
                    digest.update(buffer, 0, sizeRead);
                }
            }
            byte[] byArray = digest.digest();
            return byArray;
        }
        finally {
            log.info("digest in {} file: {}", (Object)((double)(System.nanoTime() - t1) / 1000000.0), (Object)file);
        }
    }
}

