/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.services;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.Files;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChekFileWriteService {
    private static final Logger log = LogManager.getLogger(ChekFileWriteService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkWritePermission(File dir) {
        boolean ok = dir.canWrite();
        if (ok) {
            File tmp = new File(dir, ".update-check");
            try (FileWriter writer = new FileWriter(tmp);){
                IOUtils.write((String)"OK", (Writer)writer);
            }
            catch (Exception e) {
                log.error("error de escritura en " + tmp, (Throwable)e);
                ok = false;
            }
            finally {
                try {
                    Files.deleteIfExists(tmp.toPath());
                }
                catch (Exception e) {
                    log.error("error eliminando " + tmp, (Throwable)e);
                    ok = false;
                }
            }
        }
        return ok;
    }
}

