/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.model;

import com.anf.autoupdate.client.model.FileVersion;
import com.anf.autoupdate.model.MessageController;
import com.anf.autoupdate.model.UpdateProgressListener;
import com.anf.autoupdate.text.Texts;
import java.io.File;
import java.util.List;
import javafx.scene.control.Alert;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultProgressListener
implements UpdateProgressListener {
    private static final Logger log = LogManager.getLogger(DefaultProgressListener.class);
    private MessageController messageController;

    public DefaultProgressListener(MessageController messageController) {
        this.messageController = messageController;
    }

    @Override
    public boolean checkStop() throws InterruptedException {
        return false;
    }

    @Override
    public void onBackupStart() {
        log.info("comienza el backup de los archivos");
    }

    @Override
    public void onBackupEnd() {
        log.info("termina el backup de los archivos");
    }

    @Override
    public void onRestoreStart() {
        log.info("comienza el restore de los archivos");
    }

    @Override
    public void onRestoreEnd() {
        log.info("termina el restore de los archivos");
    }

    @Override
    public void onFinishStart() {
        log.info("finalizando actualizacion");
    }

    @Override
    public void onFinishEnd(boolean success) {
        log.info("actualizacion finalizada {}", (Object)success);
    }

    @Override
    public void onUpdateFileStart(FileVersion fv) {
        log.info("descargando {}", (Object)fv.getPath());
    }

    @Override
    public void onUpdateFile(FileVersion appFile) {
        log.info("actualizado {}", (Object)appFile.getPath());
    }

    @Override
    public boolean onDeleteFileError(File appFile, FileVersion version) {
        return this.messageController.showConfirmMessage(Texts.getText("error.delete.file", appFile), Alert.AlertType.ERROR);
    }

    @Override
    public boolean onUpdateFileError(FileVersion appFile, Exception e) {
        return this.messageController.showConfirmMessage(Texts.getText("error.update.file", appFile.getPath()), e, Alert.AlertType.ERROR);
    }

    @Override
    public boolean onUpdateFilesError(Exception e) {
        return this.messageController.showConfirmMessage(Texts.getText("error.update.files", new Object[0]), e, Alert.AlertType.ERROR);
    }

    @Override
    public boolean onRestoreFileError(File appFile, Exception e) {
        return this.messageController.showConfirmMessage(Texts.getText("error.restore.file", appFile), e, Alert.AlertType.ERROR);
    }

    @Override
    public boolean onRestoreFilesError(Exception e) {
        return this.messageController.showConfirmMessage(Texts.getText("error.restore.files", new Object[0]), e, Alert.AlertType.ERROR);
    }

    @Override
    public boolean onStopRequired() {
        return this.messageController.showConfirmMessage(Texts.getText("stop.required", new Object[0]), Alert.AlertType.CONFIRMATION);
    }

    @Override
    public void onUpdateCancel() {
        this.messageController.showMessage(Texts.getText("update.cancel", new Object[0]));
    }

    @Override
    public void onUpdateStart(List<FileVersion> latestVersions) {
        if (latestVersions.isEmpty()) {
            log.info("aplicacion actualizada");
        } else {
            log.info("comienza el update de {} archivos", (Object)latestVersions.size());
            for (FileVersion version : latestVersions) {
                log.info("a actualizar: {}", (Object)version);
            }
        }
    }

    @Override
    public void onUpdateSuccess(List<File> updatedFiles) {
        log.info("se actualizaron {} archivos", (Object)updatedFiles.size());
        for (File file : updatedFiles) {
            log.info("actualizado: {}", (Object)file.getPath());
        }
    }
}

