/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.client.model;

public interface NormalizeVersion {
    default public String normalize(String version) {
        return NormalizeVersion.normalizeVersion(version);
    }

    public static String normalizeVersion(String version) {
        String[] split;
        StringBuilder sb = new StringBuilder();
        for (String part : split = version.split("\\.")) {
            sb.append(String.format("%03d", Integer.valueOf(part))).append(" ");
        }
        if (split.length == 1) {
            sb.append("000 000");
        } else if (split.length == 2) {
            sb.append("000");
        }
        return sb.toString().trim().replace(" ", ".");
    }

    default public String toVersion(String normalized) {
        String[] split;
        StringBuilder sb = new StringBuilder();
        for (String part : split = normalized.split("\\.")) {
            sb.append(Integer.valueOf(part)).append(" ");
        }
        return sb.toString().trim().replace(" ", ".");
    }

    public static boolean validate(String v1, String v2) {
        return NormalizeVersion.normalizeVersion(v1).compareTo(NormalizeVersion.normalizeVersion(v2)) > 0;
    }
}

