/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.client.model;

import com.anf.autoupdate.client.model.NormalizeVersion;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Date;

public class AppVersion
implements NormalizeVersion,
Comparable<AppVersion> {
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss", timezone="UTC")
    private Date created;
    private String appId;
    private String name;
    private String version;
    private String changes;
    private boolean test = true;
    private String config;

    public AppVersion() {
    }

    public AppVersion(String appId, String name, String version, String changes, boolean test) {
        this.appId = appId;
        this.name = name;
        this.version = version;
        this.changes = changes;
        this.test = test;
        this.created = new Date();
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.toVersion(this.version);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AppVersion)) {
            return false;
        }
        AppVersion app = (AppVersion)obj;
        return this.appId != null && app.appId != null && this.version != null && app.version != null && this.appId.equals(app.appId) && 0 == this.compareTo(app);
    }

    public int hashCode() {
        return this.appId.hashCode();
    }

    @Override
    public int compareTo(AppVersion o) {
        return this.normalize(this.version).compareTo(this.normalize(o.version));
    }

    public String toString() {
        return this.appId + " " + this.name + " " + this.version;
    }

    public String getChanges() {
        return this.changes;
    }

    public void setChanges(String changes) {
        this.changes = changes;
    }

    public boolean isTest() {
        return this.test;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }
}

