/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate;

import com.anf.autoupdate.client.DownloadFileVersionClient;
import com.anf.autoupdate.client.model.AppVersion;
import com.anf.autoupdate.client.model.FileAction;
import com.anf.autoupdate.client.model.FileVersion;
import com.anf.autoupdate.model.UpdateParams;
import com.anf.autoupdate.model.UpdateProgressListener;
import com.anf.autoupdate.registry.UpdateRegistryVersion;
import com.anf.autoupdate.services.CommandExecService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoupdateController {
    private static final Logger log = LogManager.getLogger(AutoupdateController.class);
    private DownloadFileVersionClient downloadFileClient;
    private UpdateParams params;

    public AutoupdateController(DownloadFileVersionClient downloadFileClient, UpdateParams params) {
        this.downloadFileClient = downloadFileClient;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(List<FileVersion> latestVersions) throws IOException, InterruptedException {
        boolean success = false;
        UpdateProgressListener listener = this.params.getListener();
        if (latestVersions.isEmpty()) {
            return;
        }
        AppVersion latestVersion = latestVersions.stream().map(FileVersion::getApp).max((s1, s2) -> s1.compareTo((AppVersion)s2)).orElse(null);
        if (this.params.isBackup()) {
            listener.onBackupStart();
            this.backupUpdateFiles(this.params, latestVersions);
            listener.onBackupEnd();
        }
        boolean requiresRestart = this.requiresRestart(this.params, latestVersions);
        log.info("requires restart: {}", (Object)requiresRestart);
        boolean update = true;
        try {
            listener.checkStop();
            if (requiresRestart && this.params.getStopCommands() != null && !this.params.getStopCommands().isEmpty()) {
                if (this.params.getListener().onStopRequired()) {
                    log.info("ejecutando los comandos de parada de la aplicacion");
                    CommandExecService.executeMultipleCommands(this.params.getStopCommands());
                    try {
                        TimeUnit.SECONDS.sleep(5L);
                    }
                    catch (Exception exception) {}
                } else {
                    update = false;
                }
            }
            if (update) {
                listener.checkStop();
                success = this.updateFiles(this.params, latestVersions);
                if (success) {
                    List<File> updatedFiles = latestVersions.stream().map(version -> new File(this.params.getDir(), version.getPath())).toList();
                    this.params.onUpdateSuccess(updatedFiles);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            if (update && !success && this.params.isBackup()) {
                listener.onRestoreStart();
                this.restoreFiles(this.params, latestVersions);
                listener.onRestoreEnd();
            }
            listener.onFinishStart();
            if (this.params.isBackup()) {
                this.deleteBackupFiles(this.params, latestVersions);
            }
            if (update && success) {
                this.params.updateConfigFile(latestVersion);
                log.info("actualizado a la ultima version: {}", (Object)latestVersion);
            }
            if (update && requiresRestart && this.params.getStartCommands() != null && !this.params.getStartCommands().isEmpty()) {
                CommandExecService.executeMultipleCommands(this.params.getStartCommands());
            }
            if (update) {
                UpdateRegistryVersion.updateVersion(latestVersion.getName(), latestVersion.getVersion());
            }
            if (update) {
                listener.onFinishEnd(success);
            } else {
                listener.onUpdateCancel();
            }
        }
    }

    private void deleteBackupFiles(UpdateParams params, List<FileVersion> latestVersions) {
        File backupDir = params.backupDir();
        if (backupDir.exists()) {
            try {
                for (FileVersion version : latestVersions) {
                    File backupFile = new File(backupDir, version.getPath());
                    if (!backupFile.exists() || FileUtils.deleteQuietly((File)backupFile)) continue;
                    log.error("no se pudo eliminar archivo de backup: " + backupFile);
                }
                if (backupDir.exists() && !FileUtils.deleteQuietly((File)backupDir)) {
                    log.error("no se pudo eliminar la carpeta de backup: " + backupDir);
                }
                if (params.getTmpDir().exists() && !FileUtils.deleteQuietly((File)params.getTmpDir())) {
                    log.error("no se pudo eliminar la carpeta temporal: " + params.getTmpDir());
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    private boolean requiresRestart(UpdateParams params, List<FileVersion> latestVersions) {
        List<String> restartRequiredFilters = params.getRestartRequiredFilters();
        if (restartRequiredFilters != null && !restartRequiredFilters.isEmpty()) {
            for (FileVersion version : latestVersions) {
                for (String filter : restartRequiredFilters) {
                    if (!new File(version.getPath()).getName().contains(filter)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void restoreFiles(UpdateParams params, List<FileVersion> latestVersions) {
        File backupDir = params.backupDir();
        if (backupDir.exists()) {
            try {
                for (FileVersion version : latestVersions) {
                    File appFile = new File(params.getDir(), version.getPath());
                    boolean restoreFile = !appFile.exists() || version.isUpdated() && version.getError() == null;
                    if (!restoreFile) continue;
                    this.restoreFile(params, backupDir, version, appFile);
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                params.onRestoreFilesError(e);
            }
        }
    }

    private boolean restoreFile(UpdateParams params, File backupDir, FileVersion version, File appFile) {
        try {
            File backupFile = new File(backupDir, version.getPath());
            log.info("restaurando archivo {} en {}", (Object)backupFile.getCanonicalPath(), (Object)appFile.getCanonicalFile());
            Files.copy(backupFile.toPath(), appFile.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            return appFile.exists() && appFile.length() == backupFile.length() && Files.deleteIfExists(backupFile.toPath());
        }
        catch (Exception e) {
            while (params.onRestoreFileError(appFile, e) && !this.restoreFile(params, backupDir, version, appFile)) {
            }
            return false;
        }
    }

    private boolean updateFiles(UpdateParams params, List<FileVersion> latestVersions) throws Exception {
        try {
            boolean stop = this.deleteUpdateFiles(params, latestVersions);
            if (!stop) {
                for (FileVersion version : latestVersions) {
                    if (stop) break;
                    File appFile = new File(params.getDir(), version.getPath());
                    do {
                        try {
                            params.getListener().checkStop();
                            params.onUpdateFileStart(version);
                            params.getListener().checkStop();
                            boolean updateFile = this.updateFile(params, version, appFile);
                            if (!updateFile) {
                                throw new Exception("ERR_UPDATE_FILE:" + appFile);
                            }
                            params.getListener().checkStop();
                            params.onUpdateFile(version);
                            version.setUpdated(updateFile);
                        }
                        catch (InterruptedException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            version.setError(e);
                            log.error("error al actualizar el archivo " + appFile, (Throwable)e);
                            if (params.onUpdateFileError(version, e)) continue;
                            stop = true;
                        }
                    } while (!stop && !version.isUpdated());
                }
            }
            if (!stop) {
                this.deleteEmptyDirs(params, latestVersions);
            }
            return !stop;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            boolean ok = false;
            while ((ok = params.onUpdateFilesError(e)) && !(ok = this.updateFiles(params, latestVersions))) {
            }
            if (!ok) {
                throw e;
            }
            return false;
        }
    }

    private void deleteEmptyDirs(UpdateParams params, List<FileVersion> latestVersions) throws IOException, InterruptedException {
        block0: for (FileVersion version : latestVersions) {
            File appFile;
            File parent = appFile = new File(params.getDir(), version.getPath());
            params.getListener().checkStop();
            do {
                if ((parent = parent.getParentFile()) == null || !parent.exists()) continue;
                String[] files = parent.list();
                if (files != null && files.length != 0) continue block0;
                FileUtils.deleteQuietly((File)parent);
            } while (parent != null && parent.getParentFile() != null && !parent.getParentFile().getCanonicalPath().equals(params.getDir().getCanonicalPath()));
        }
    }

    private boolean updateFile(UpdateParams params, FileVersion version, File appFile) throws IOException, InterruptedException {
        if (version.getAction() == FileAction.ADD || version.getAction() == FileAction.UPDATE) {
            boolean bl;
            params.getListener().checkStop();
            appFile.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(appFile);
            try {
                this.downloadFileClient.downloadFileVersion(version, out);
                bl = appFile.exists() && appFile.length() == version.getSize();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    while (params.onUpdateFileError(version, e) && !this.updateFile(params, version, appFile)) {
                    }
                    throw new RuntimeException("ERR_UPDATE_FILE:" + appFile);
                }
            }
            out.close();
            return bl;
        }
        if (version.getAction() == FileAction.DELETE) {
            return this.deleteAppFile(params, appFile, version);
        }
        return true;
    }

    private boolean deleteUpdateFiles(UpdateParams params, List<FileVersion> latestVersions) throws IOException, InterruptedException {
        boolean stop = false;
        for (FileVersion version : latestVersions) {
            File appFile = new File(params.getDir(), version.getPath());
            boolean deleted = !appFile.exists();
            do {
                params.getListener().checkStop();
                try {
                    if (deleted) continue;
                    deleted = this.deleteAppFile(params, appFile, version);
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (IOException e) {
                    version.setError(e);
                    log.error("error eliminando archivo " + appFile, (Throwable)e);
                }
            } while (!deleted && !(stop = !params.onDeleteFileError(appFile, version)));
        }
        return stop;
    }

    private void backupUpdateFiles(UpdateParams params, List<FileVersion> latestVersions) throws IOException {
        for (FileVersion version : latestVersions) {
            File appFile = new File(params.getDir(), version.getPath());
            if (!appFile.exists()) continue;
            File backup = params.backupDir();
            File backupFile = new File(backup, version.getPath());
            Files.deleteIfExists(backupFile.toPath());
            backupFile.getParentFile().mkdirs();
            log.info("backing up file {} to backup: {}", (Object)appFile, (Object)backupFile);
            Files.copy(appFile.toPath(), backupFile.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private boolean deleteAppFile(UpdateParams params, File appFile, FileVersion version) throws IOException, InterruptedException {
        log.info("trying to delete file: " + appFile);
        if (appFile.getName().equals("anf-elevate.exe")) {
            try {
                Runtime.getRuntime().exec("taskkill /F /IM \"anf-elevate.exe\"");
            }
            catch (Exception e) {
                log.error("no se pudo terminar el proceso anf-elevate.exe", (Throwable)e);
            }
        }
        while (appFile.exists() && !Files.deleteIfExists(appFile.toPath()) && !params.getListener().checkStop() && params.onDeleteFileError(appFile, version)) {
        }
        return !appFile.exists();
    }
}

