/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate;

import com.anf.autoupdate.AutoupdateApplicationExecutor;
import com.anf.autoupdate.AutoupdateCheck;
import com.anf.autoupdate.AutoupdateCopy;
import com.anf.trust.certs.TrustFactory;
import java.io.File;
import java.net.ServerSocket;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoupdateCommand {
    public static final int COPY_PORT = 36745;
    public static final int UPDATE_PORT = 36746;
    public static final int CHECK_PORT = 36747;
    private static final Logger log = LogManager.getLogger(AutoupdateCommand.class);

    public static void main(String[] args) {
        try {
            if (args != null && args.length >= 2) {
                File path = new File(args[1]);
                if (path.exists()) {
                    new TrustFactory(true).configureTLS();
                    String command = args[0];
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> log.info("finaliza el proceso: {}", (Object)String.join((CharSequence)" ", args))));
                    log.info(System.getenv("PATH"));
                    switch (command) {
                        case "tmp-copy": {
                            log.info("ejecutando copia temporal");
                            AutoupdateCommand.lock(36745, () -> AutoupdateCopy.launch(args[1]));
                            break;
                        }
                        case "update": 
                        case "update-silent": {
                            log.info("ejecutando actualizacion {}", (Object)command);
                            AutoupdateCommand.lock(36746, () -> AutoupdateApplicationExecutor.executeUpdateApplication(args));
                            break;
                        }
                        case "check": {
                            log.info("ejecutando comprobacion");
                            AutoupdateCheck.checkUpdate(path, args);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected value: " + command);
                        }
                    }
                } else {
                    log.warn("la ruta no existe o no es un directorio: {}", (Object)path);
                }
            } else {
                AutoupdateCommand.printUsage();
            }
        }
        catch (Exception e) {
            log.error("autoupdate command error", (Throwable)e);
            System.exit(-1);
        }
    }

    private static void printUsage() {
        log.warn("Forma de utilizar:\npara actualizar:              update <path>\npara realizar copia temporal: tmp-copy <path>");
        try {
            new File("C:\\autoupdate-temp\\error").mkdirs();
            TimeUnit.SECONDS.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void lock(int port, Runnable action) {
        log.info("locking {}", (Object)port);
        try (ServerSocket socket = new ServerSocket(port);){
            log.info("locked ok {}", (Object)socket.getLocalPort());
            try {
                action.run();
            }
            catch (Exception e) {
                log.error("error en la accion de autoupdate", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("ya hay otro proceso del autoupdate en ejecucion por el puerto " + port);
        }
    }
}

