/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.request.upload.client.impl;

import com.anf.cert.client.AbstractCertClient;
import com.anf.cert.client.ClientConfig;
import com.anf.cert.generator.CertGenerationResult;
import com.anf.cert.profile.CertProfile;
import com.anf.cert.profile.ContactInfo;
import com.anf.cert.request.upload.client.CertUploadClient;
import com.anf.cert.request.upload.client.request.CSRInsertRequest;
import com.anf.cert.request.upload.client.request.CertUploadRequest;
import com.anf.cert.request.upload.client.response.CertUploadResponse;
import com.anf.cert.request.upload.exception.CertRequestUploadException;
import com.anf.pkcs10.PKCS10Request;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class DefaultCertUploadClient
extends AbstractCertClient
implements CertUploadClient {
    public DefaultCertUploadClient(ClientConfig config) {
        super(config);
    }

    @Override
    public CertUploadResponse uploadSSL(String localizator, CertProfile profile, CertGenerationResult result, String statusUrl) throws CertRequestUploadException {
        CertUploadResponse response = new CertUploadResponse();
        PKCS10Request csr = result.getPkcs10();
        String csrRequest = this.generatePKCS10RequestPEM(csr);
        BigInteger serialNumber = result.getSelfSignedCert().getSerialNumber();
        System.out.println(csrRequest);
        CertUploadRequest request = new CertUploadRequest(localizator, result.getPolicy(), csrRequest, serialNumber.toString());
        request.setStatusUrl(statusUrl);
        try {
            response = (CertUploadResponse)((Object)this.handleJsonRequest("/ssl-request/upload", (Object)request, CertUploadResponse.class).get());
        }
        catch (Throwable e) {
            throw new CertRequestUploadException(e);
        }
        return response;
    }

    @Override
    public CertUploadResponse uploadCSR(String profile, ContactInfo contactInfo, PKCS10Request csr) throws CertRequestUploadException {
        CertUploadResponse response = new CertUploadResponse();
        String csrRequest = this.generatePKCS10RequestPEM(csr);
        CSRInsertRequest request = new CSRInsertRequest(csrRequest, profile, contactInfo);
        try {
            response = (CertUploadResponse)((Object)this.handleJsonRequest("/csr-request", (Object)request, CertUploadResponse.class).get());
        }
        catch (Throwable e) {
            throw new CertRequestUploadException(e);
        }
        return response;
    }

    private String generatePKCS10RequestPEM(PKCS10Request csr) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(outputStream));){
            pemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE REQUEST", csr.getEncoded()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String csrRequest = new String(outputStream.toByteArray());
        return csrRequest;
    }
}

