/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.registry.client.request;

import com.anf.cert.generator.pkcs10.PKCS10Generator;
import com.anf.cert.profile.CertProfile;
import com.anf.cert.profile.attributes.CertAttributes;
import com.anf.cert.profile.attributes.EVAttributes;
import com.anf.cert.profile.attributes.PSD2Attributes;
import com.anf.cert.profile.attributes.SealAttributes;
import com.anf.cert.profile.attributes.SedeAttributes;
import com.anf.cert.profile.attributes.impl.CertAttributesImpl;
import com.anf.cert.profile.attributes.impl.EVAttributesImpl;
import com.anf.cert.profile.attributes.impl.PSD2AttributesImpl;
import com.anf.cert.profile.attributes.impl.SealAttributesImpl;
import com.anf.cert.profile.attributes.impl.SedeAttributesImpl;
import com.anf.cert.profile.impl.seal.SealProfileAPAlto;
import com.anf.cert.profile.impl.seal.SealProfileAPMedio;
import com.anf.cert.profile.impl.seal.SealProfileImpl;
import com.anf.cert.profile.impl.seal.SealProfilePSD2;
import com.anf.cert.profile.impl.sede.SedeEVAltoProfile;
import com.anf.cert.profile.impl.sede.SedeEVMedioProfile;
import com.anf.cert.profile.impl.ssl.DVSSLProfileImpl;
import com.anf.cert.profile.impl.ssl.EVSSLProfileImpl;
import com.anf.cert.profile.impl.ssl.OVSSLProfileImpl;
import com.anf.cert.profile.impl.ssl.PSD2SSLProfileImpl;
import com.anf.cert.psd2.PSD2CountryNCAService;
import com.anf.cert.psd2.Psd2NCAInfo;
import com.anf.cryptotoken.utils.DatosPersonales;
import com.anf.oauth.json.BasicRequest;
import com.anf.pkcs10.PKCS10Request;
import com.anf.pkcs10.utils.ASN1Utils;
import com.anf.pkcs10.utils.PKCS10Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class CSRProfileRegistryRequest
extends BasicRequest {
    private String profile;
    private String csr;
    private EVAttributes evAttributes;
    private SealAttributes sealAttributes;
    private PSD2Attributes psd2Attributes;
    private SedeAttributes sedeAttributes;
    private CertAttributes certAttributes;
    private String[] domains;
    private boolean test = false;
    private String requester;
    private String policy;

    public CSRProfileRegistryRequest(String profile) {
        this.profile = profile;
    }

    public CSRProfileRegistryRequest(String profile, String csr) {
        this.profile = profile;
        this.csr = csr;
    }

    public String getCsr() {
        return this.csr;
    }

    public void setCsr(String csr) {
        this.csr = csr;
    }

    public EVAttributes getEvAttributes() {
        return this.evAttributes;
    }

    public void setEvAttributes(EVAttributes evAttributes) {
        this.evAttributes = evAttributes;
    }

    public SealAttributes getSealAttributes() {
        return this.sealAttributes;
    }

    public void setSealAttributes(SealAttributes sealAttributes) {
        this.sealAttributes = sealAttributes;
    }

    public PSD2Attributes getPsd2Attributes() {
        return this.psd2Attributes;
    }

    public void setPsd2Attributes(PSD2Attributes psd2Attributes) {
        this.psd2Attributes = psd2Attributes;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setDomains(String[] domains) {
        this.domains = domains;
    }

    public String[] getDomains() {
        return this.domains;
    }

    public SedeAttributes getSedeAttributes() {
        return this.sedeAttributes;
    }

    public void setSedeAttributes(SedeAttributes sedeAttributes) {
        this.sedeAttributes = sedeAttributes;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public boolean isTest() {
        return this.test;
    }

    public String getRequester() {
        return this.requester;
    }

    public void setRequester(String requester) {
        this.requester = requester;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public void setCertAttributes(CertAttributes attr) {
        this.certAttributes = attr;
    }

    public CertAttributes getCertAttributes() {
        return this.certAttributes;
    }

    public static CSRProfileRegistryRequest generateFromPKCS10(String profile, File pkcs10File) throws Exception {
        String csr = null;
        try (FileInputStream in = new FileInputStream(pkcs10File);){
            csr = new String(IOUtils.toByteArray((InputStream)in));
        }
        return CSRProfileRegistryRequest.generateFromPKCS10(profile, csr);
    }

    public static CSRProfileRegistryRequest generateFromPKCS10(String profile, String csr) throws IOException, Exception {
        PKCS10Request pkcs10 = PKCS10Utils.loadPKCS10((String)csr);
        return CSRProfileRegistryRequest.generateFromPKCS10(profile, csr, pkcs10);
    }

    public static CSRProfileRegistryRequest generateFromPKCS10(String profile, String csr, PKCS10Request pkcs10) throws Exception {
        SedeAttributes sedeAttributes;
        SealAttributes sealAttributes;
        GeneralNames names;
        int sepInd;
        CSRProfileRegistryRequest request = new CSRProfileRegistryRequest(profile, Base64.getEncoder().encodeToString(csr.getBytes()));
        X500Name subject = pkcs10.getSubject();
        Function<String, String> getValue = oid -> (String)ASN1Utils.matchRDNValue((RDN[])subject.getRDNs(), (cur, enc) -> cur.getId().equals(oid) ? enc.toString() : null);
        DatosPersonales dp = new DatosPersonales(subject);
        RSAPublicKey publicKey = (RSAPublicKey)PKCS10Utils.extractPublicKey((PKCS10Request)pkcs10);
        int keySize = publicKey.getModulus().bitLength();
        String orgId = null;
        String psd2AuthNumber = null;
        String nif = dp.getSERIALNUMBER();
        orgId = getValue.apply("2.5.4.97");
        if (orgId != null && (sepInd = orgId.lastIndexOf("-")) < orgId.length() - 1) {
            String substr = orgId.substring(sepInd + 1);
            if (orgId.startsWith("VAT")) {
                nif = substr;
            } else if (orgId.startsWith("PSD")) {
                psd2AuthNumber = substr;
            }
        }
        CertAttributesImpl attr = new CertAttributesImpl(nif, dp.getCN(), dp.getO(), dp.getOU(), dp.getL(), dp.getST(), dp.getC(), keySize);
        request.setCertAttributes((CertAttributes)attr);
        String email = dp.getEMAILADDRESS();
        Extensions exts = CSRProfileRegistryRequest.getExtensions(pkcs10);
        if (exts != null && (names = GeneralNames.fromExtensions((Extensions)exts, (ASN1ObjectIdentifier)Extension.subjectAlternativeName)) != null) {
            GeneralName[] namesArray;
            TreeSet<String> domainsSet = new TreeSet<String>();
            if (request.getDomains() != null) {
                for (String domain : request.getDomains()) {
                    domainsSet.add(domain);
                }
            }
            for (GeneralName name : namesArray = names.getNames()) {
                if (name.getTagNo() == 2) {
                    domainsSet.add(name.getName().toString().trim());
                    continue;
                }
                if (name.getTagNo() != 1) continue;
                email = name.getName().toString();
            }
            if (!domainsSet.isEmpty()) {
                String[] domains = new String[domainsSet.size()];
                request.setDomains(domainsSet.toArray(domains));
            } else {
                request.setDomains(null);
            }
        }
        if (profile.contains("SEAL") && (sealAttributes = request.getSealAttributes()) == null) {
            sealAttributes = new SealAttributesImpl(null, dp.getT(), dp.getGIVENNAME(), dp.getSURNAME(), email, dp.getCN());
            request.setSealAttributes(sealAttributes);
        }
        if (profile.contains("PSD2")) {
            Psd2NCAInfo nca;
            PSD2Attributes psd2Attributes = request.getPsd2Attributes();
            if (psd2Attributes == null) {
                psd2Attributes = new PSD2AttributesImpl();
                request.setPsd2Attributes(psd2Attributes);
            }
            if ((nca = PSD2CountryNCAService.get().getNCA(dp.getC())) != null) {
                psd2Attributes.setCountryCode(nca.getCountry());
                psd2Attributes.setIdNCA(nca.getIdNCA());
                psd2Attributes.setNameNCA(nca.getNameNCA());
                psd2Attributes.setAuthNumber(psd2AuthNumber);
            }
        }
        if (profile.equals("SSL_EV") || profile.equals("QWAC")) {
            EVAttributes evAttributes = request.getEvAttributes();
            evAttributes = new EVAttributesImpl(null, null);
            request.setEvAttributes(evAttributes);
            String businessCategory = getValue.apply("2.5.4.15");
            evAttributes.setBusinessCategory(businessCategory);
            String jurisdictionLocalityName = getValue.apply("1.3.6.1.4.1.311.60.2.1.1");
            if (jurisdictionLocalityName == null) {
                jurisdictionLocalityName = dp.getL();
            }
            evAttributes.setJurisdictionLocalityName(jurisdictionLocalityName);
            String jurisdictionStateOrProvinceName = getValue.apply("1.3.6.1.4.1.311.60.2.1.2");
            if (jurisdictionStateOrProvinceName == null) {
                jurisdictionStateOrProvinceName = dp.getST();
            }
            evAttributes.setJurisdictionStateOrProvinceName(jurisdictionStateOrProvinceName);
            String jurisdictionCountryName = getValue.apply("1.3.6.1.4.1.311.60.2.1.3");
            if (jurisdictionCountryName == null) {
                jurisdictionCountryName = dp.getC();
            }
            evAttributes.setJurisdictionCountryName(jurisdictionCountryName);
        }
        if (profile.contains("SEDE") && (sedeAttributes = request.getSedeAttributes()) == null) {
            sedeAttributes = new SedeAttributesImpl(dp.getCN(), dp.getGIVENNAME(), dp.getSURNAME());
            request.setSedeAttributes(sedeAttributes);
        }
        return request;
    }

    private static Extensions getExtensions(PKCS10Request pkcs10) {
        ASN1Encodable encodableSet;
        ASN1Encodable oid;
        ASN1Sequence attrSeq;
        Enumeration seqObjects;
        ASN1Set attributesSet = pkcs10.getAttributesSet();
        if (attributesSet != null && attributesSet.getObjects().hasMoreElements() && (seqObjects = (attrSeq = (ASN1Sequence)attributesSet.getObjectAt(0)).getObjects()).hasMoreElements() && (oid = (ASN1Encodable)seqObjects.nextElement()) instanceof ASN1ObjectIdentifier && ((ASN1ObjectIdentifier)oid).getId().equals("1.2.840.113549.1.9.14") && seqObjects.hasMoreElements() && (encodableSet = (ASN1Encodable)seqObjects.nextElement()) instanceof ASN1Set && ((ASN1Set)encodableSet).getObjects().hasMoreElements()) {
            ASN1Encodable encSeq = ((ASN1Set)encodableSet).getObjectAt(0);
            try {
                Extensions exts = Extensions.getInstance((Object)encSeq);
                return exts;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public CertProfile buildCertProfile() {
        DVSSLProfileImpl certProfile = null;
        switch (this.profile) {
            case "QWAC": 
            case "SSL_EV": {
                certProfile = new EVSSLProfileImpl(this.certAttributes, this.evAttributes, this.domains);
                break;
            }
            case "SSL_DV": {
                certProfile = new DVSSLProfileImpl(this.domains);
                break;
            }
            case "SSL_OV": {
                certProfile = new OVSSLProfileImpl(this.certAttributes, this.domains);
                break;
            }
            case "QWAC_PSD2": 
            case "SSL_PSD2": {
                certProfile = new PSD2SSLProfileImpl(this.certAttributes, this.evAttributes, this.psd2Attributes, this.domains);
                break;
            }
            case "QSEALC": {
                certProfile = new SealProfileImpl(this.certAttributes, this.sealAttributes);
                break;
            }
            case "QSEAL_PSD2": 
            case "QSEALC_PSD2": 
            case "SEAL_PSD2": {
                certProfile = new SealProfilePSD2(this.certAttributes, this.sealAttributes, this.psd2Attributes);
                break;
            }
            case "QSEAL_AP_MEDIO": {
                certProfile = new SealProfileAPMedio(this.certAttributes, this.sealAttributes);
                break;
            }
            case "QSEAL_AP_ALTO": {
                certProfile = new SealProfileAPAlto(this.certAttributes, this.sealAttributes);
                break;
            }
            case "SEDE_EV": 
            case "SEDE_EV_MEDIO": {
                certProfile = new SedeEVMedioProfile(this.certAttributes, this.sedeAttributes, this.evAttributes, new String[0]);
                break;
            }
            case "SEDE_EV_ALTO": {
                certProfile = new SedeEVAltoProfile(this.certAttributes, this.sedeAttributes, this.evAttributes, new String[0]);
            }
        }
        certProfile.setTestCertificate(this.test);
        return certProfile;
    }

    public String buildPKCS10() throws Exception {
        KeyPairGenerator keysGen = KeyPairGenerator.getInstance("RSA", "BC");
        keysGen.initialize(this.certAttributes.getKeySize());
        KeyPair keyPair = keysGen.generateKeyPair();
        return this.buildPKCS10(keyPair);
    }

    public String buildPKCS10(KeyPair keyPair) throws Exception {
        JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder("SHA256withRSA");
        ContentSigner contentSigner = contentSignerBuilder.build(keyPair.getPrivate());
        X500Name subject = this.buildCertProfile().createSubject();
        ArrayList<GeneralName> alternativeNames = new ArrayList<GeneralName>();
        if (this.domains != null) {
            for (String domain : this.domains) {
                alternativeNames.add(new GeneralName(2, domain));
            }
        }
        if (this.sealAttributes != null && this.sealAttributes.getEmail() != null) {
            alternativeNames.add(new GeneralName(1, this.sealAttributes.getEmail()));
        }
        ASN1Sequence qcStatements = null;
        PKCS10Request pkcs10 = PKCS10Generator.generatePKCS10(keyPair.getPublic(), subject, alternativeNames, qcStatements, contentSigner);
        PKCS10CertificationRequest req = new PKCS10CertificationRequest(pkcs10.getEncoded());
        StringWriter writer = new StringWriter();
        try (JcaPEMWriter csrwriter = new JcaPEMWriter((Writer)writer);){
            csrwriter.writeObject((Object)req);
        }
        this.csr = writer.getBuffer().toString();
        return this.csr;
    }
}

