/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.generator.pkcs10;

import com.anf.pkcs10.PKCS10Request;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public interface PKCS10Writer {
    public static void writePKCS10(PKCS10Request pkcs10, File csr, String format) throws IOException {
        if (pkcs10 != null && csr != null) {
            csr.getCanonicalFile().getParentFile().mkdirs();
            if (format == null) {
                format = "PEM";
            }
            switch (format) {
                case "PEM": {
                    PKCS10CertificationRequest req = new PKCS10CertificationRequest(pkcs10.getEncoded());
                    FileWriter writer = new FileWriter(csr);
                    try (JcaPEMWriter csrwriter = new JcaPEMWriter((Writer)writer);){
                        csrwriter.writeObject((Object)req);
                        break;
                    }
                }
                case "DER": {
                    try (FileOutputStream out = new FileOutputStream(csr);){
                        IOUtils.write((byte[])pkcs10.getEncoded(), (OutputStream)out);
                        break;
                    }
                }
            }
        }
    }
}

