/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.generator.impl;

import com.anf.cert.generator.CertGenerationResult;
import com.anf.cert.generator.CertGenerator;
import com.anf.cert.generator.exception.CertGenerationException;
import com.anf.cert.generator.impl.CertDefaultResult;
import com.anf.cert.generator.pkcs10.PKCS10Writer;
import com.anf.cert.profile.APSealProfile;
import com.anf.cert.profile.CertProfile;
import com.anf.cert.profile.PSD2SealProfile;
import com.anf.cert.profile.SealProfile;
import com.anf.cryptotoken.ANFControl;
import com.anf.cryptotoken.ANFCryptoToken;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.cryptotoken.tkmanager.ManagerType;
import com.anf.cryptotoken.tkmanager.TKManager;
import com.anf.pkcs10.PKCS10Creator;
import com.anf.pkcs10.PKCS10Request;
import com.anf.pkcs10.PKCS10RequestFactory;
import com.anf.pkcs10.impl.PKCS10CreatorV2;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

public class PKCS11CertGenerator
implements CertGenerator {
    private static final Logger log = Logger.getLogger(PKCS11CertGenerator.class);
    private CertProfile profile;
    private File csr;
    private int defaultDaysExpiration = 90;
    private String signatureAlgorithm = "SHA256withRSA";
    private String deviceSerialNumber;
    private ManagerType type;

    public PKCS11CertGenerator(CertProfile profile, File csr, ManagerType type, String deviceSerialNumber) {
        this.profile = profile;
        this.csr = csr;
        this.deviceSerialNumber = deviceSerialNumber;
        this.type = type;
    }

    @Override
    public CertGenerationResult createCert(char[] ignore) throws CertGenerationException {
        CertDefaultResult result = null;
        try {
            ANFCryptoToken p11 = ANFControl.get().getInstance(this.type);
            TKManager token = p11.findTokenBySerialNumber(this.deviceSerialNumber);
            if (token == null) {
                throw new CertGenerationException("ERR_DEVICE_SERIAL_NUMBER_NOT_FOUND");
            }
            X500Name subject = this.profile.createSubject();
            ASN1Sequence qcStatements = null;
            ASN1Set attributes = this.generateCSRAttributes(this.profile.getSubjectAltNames(), qcStatements);
            BigInteger serial = new BigInteger(64, new Random(System.nanoTime()));
            Calendar cal = Calendar.getInstance();
            Date notBefore = cal.getTime();
            cal.add(6, this.defaultDaysExpiration);
            Date notAfter = cal.getTime();
            int keySize = this.profile.getKeyLength();
            token.setPkcs10Creator((PKCS10Creator)new PKCS10CreatorV2());
            byte[] p10 = p11.generateRequest(this.deviceSerialNumber, subject, serial, notBefore, notAfter, keySize, attributes, this.signatureAlgorithm);
            PKCS10Request pkcs10 = PKCS10RequestFactory.createNewPKCS10((byte[])p10);
            try {
                PKCS10Writer.writePKCS10(pkcs10, this.csr, "PEM");
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            X509Certificate generatedCert = null;
            LinkedList certificates = token.getCertificates();
            for (X509Certificate cert : certificates) {
                if (!cert.getSerialNumber().toString().equals(serial.toString())) continue;
                generatedCert = cert;
                break;
            }
            Object policy = this.profile.getPolicyOid();
            if (this.profile instanceof PSD2SealProfile) {
                policy = "1.3.6.1.4.1.18332." + ProfilePolicy.QSeal_PSD2_QSCD.getOid();
            } else if (this.profile instanceof SealProfile) {
                policy = "1.3.6.1.4.1.18332." + ProfilePolicy.QSeal_QSCD.getOid();
            } else if (this.profile instanceof APSealProfile) {
                policy = "1.3.6.1.4.1.18332." + ProfilePolicy.QSeal_AP_QSCD.getOid();
            }
            result = new CertDefaultResult(pkcs10, generatedCert, p11.getKeyStore(this.deviceSerialNumber), (String)policy);
        }
        catch (Exception e) {
            throw new CertGenerationException(e);
        }
        return result;
    }

    private ASN1Set generateCSRAttributes(List<GeneralName> alternativeNames, ASN1Sequence qcStatements) throws IOException {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        GeneralName[] array = new GeneralName[alternativeNames.size()];
        GeneralNames generalNames = new GeneralNames(alternativeNames.toArray(array));
        Extension ext = new Extension(Extension.subjectAlternativeName, false, generalNames.getEncoded());
        vector.add((ASN1Encodable)ext);
        if (qcStatements != null) {
            ext = new Extension(Extension.qCStatements, false, qcStatements.getEncoded());
            vector.add((ASN1Encodable)ext);
        }
        DERSet set = new DERSet(vector);
        return set;
    }
}

