/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import eu.europa.esig.dss.spi.x509.TrustedCertificateSource;
import java.util.Collections;
import java.util.List;

public class CommonTrustedCertificateSource
extends CommonCertificateSource
implements TrustedCertificateSource {
    @Override
    public CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.TRUSTED_STORE;
    }

    public void importAsTrusted(CertificateSource certificateSource) {
        List<CertificateToken> certTokenList = certificateSource.getCertificates();
        for (CertificateToken certToken : certTokenList) {
            this.addCertificate(certToken);
        }
    }

    @Override
    public List<String> getAlternativeOCSPUrls(CertificateToken trustAnchor) {
        return Collections.emptyList();
    }

    @Override
    public List<String> getAlternativeCRLUrls(CertificateToken trustAnchor) {
        return Collections.emptyList();
    }

    @Override
    public boolean isTrusted(CertificateToken certificateToken) {
        return this.isKnown(certificateToken);
    }
}

