/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation;

import eu.europa.esig.dss.alert.StatusAlert;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.validation.SignatureValidationContext;
import eu.europa.esig.dss.spi.validation.ValidationAlerter;
import eu.europa.esig.dss.spi.validation.status.RevocationFreshnessStatus;
import eu.europa.esig.dss.spi.validation.status.SignatureStatus;
import eu.europa.esig.dss.spi.validation.status.TokenStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureValidationAlerter
implements ValidationAlerter {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureValidationAlerter.class);
    private final SignatureValidationContext validationContext;

    public SignatureValidationAlerter(SignatureValidationContext validationContext) {
        this.validationContext = validationContext;
    }

    @Override
    public void assertAllRequiredRevocationDataPresent() {
        StatusAlert alertOnMissingRevocationData = this.validationContext.getCertificateVerifier().getAlertOnMissingRevocationData();
        if (alertOnMissingRevocationData == null) {
            LOG.trace("The verification of #assertAllRequiredRevocationDataPresent has been skipped. Please define CertificateVerifier#alertOnMissingRevocationData to execute validation.");
            return;
        }
        TokenStatus status = this.validationContext.allRequiredRevocationDataPresent();
        boolean success = status.isEmpty();
        if (!success) {
            alertOnMissingRevocationData.alert((Object)status);
        }
    }

    @Override
    public void assertAllPOECoveredByRevocationData() {
        StatusAlert alertOnUncoveredPOE = this.validationContext.getCertificateVerifier().getAlertOnUncoveredPOE();
        if (alertOnUncoveredPOE == null) {
            LOG.trace("The verification of #assertAllRequiredRevocationDataPresent has been skipped. Please define CertificateVerifier#alertOnUncoveredPOE to execute validation.");
            return;
        }
        RevocationFreshnessStatus status = this.validationContext.allPOECoveredByRevocationData();
        boolean success = status.isEmpty();
        if (!success) {
            alertOnUncoveredPOE.alert((Object)status);
        }
    }

    @Override
    public void assertAllTimestampsValid() {
        StatusAlert alertOnInvalidTimestamp = this.validationContext.getCertificateVerifier().getAlertOnInvalidTimestamp();
        if (alertOnInvalidTimestamp == null) {
            LOG.trace("The verification of #assertAllTimestampsValid has been skipped. Please define CertificateVerifier#alertOnInvalidTimestamp to execute validation.");
            return;
        }
        TokenStatus status = this.validationContext.allTimestampsValid();
        boolean success = status.isEmpty();
        if (!success) {
            alertOnInvalidTimestamp.alert((Object)status);
        }
    }

    @Override
    public void assertCertificateNotRevoked(CertificateToken certificateToken) {
        StatusAlert alertOnRevokedCertificate = this.validationContext.getCertificateVerifier().getAlertOnRevokedCertificate();
        if (alertOnRevokedCertificate == null) {
            LOG.trace("The verification of #assertCertificateNotRevoked has been skipped. Please define CertificateVerifier#alertOnRevokedCertificate to execute validation.");
            return;
        }
        TokenStatus status = this.validationContext.certificateNotRevoked(certificateToken);
        boolean success = status.isEmpty();
        if (!success) {
            alertOnRevokedCertificate.alert((Object)status);
        }
    }

    @Override
    public void assertAllSignatureCertificatesNotRevoked() {
        StatusAlert alertOnRevokedCertificate = this.validationContext.getCertificateVerifier().getAlertOnRevokedCertificate();
        if (alertOnRevokedCertificate == null) {
            LOG.trace("The verification of #assertAllSignatureCertificatesNotRevoked has been skipped. Please define CertificateVerifier#alertOnRevokedCertificate to execute validation.");
            return;
        }
        TokenStatus status = this.validationContext.allSignatureCertificatesNotRevoked();
        boolean success = status.isEmpty();
        if (!success) {
            alertOnRevokedCertificate.alert((Object)status);
        }
    }

    @Override
    public void assertAllSignatureCertificateHaveFreshRevocationData() {
        StatusAlert alertOnNoRevocationAfterBestSignatureTime = this.validationContext.getCertificateVerifier().getAlertOnNoRevocationAfterBestSignatureTime();
        if (alertOnNoRevocationAfterBestSignatureTime == null) {
            LOG.trace("The verification of #assertAllSignatureCertificateHaveFreshRevocationData has been skipped. Please define CertificateVerifier#alertOnNoRevocationAfterBestSignatureTime to execute validation.");
            return;
        }
        RevocationFreshnessStatus status = this.validationContext.allSignatureCertificateHaveFreshRevocationData();
        boolean success = status.isEmpty();
        if (!success) {
            alertOnNoRevocationAfterBestSignatureTime.alert((Object)status);
        }
    }

    @Override
    public void assertAllSignaturesNotExpired() {
        StatusAlert alertOnExpiredCertificate = this.validationContext.getCertificateVerifier().getAlertOnExpiredCertificate();
        if (alertOnExpiredCertificate == null) {
            LOG.trace("The verification of #assertAllSignaturesNotExpired has been skipped. Please define CertificateVerifier#alertOnExpiredCertificate to execute validation.");
            return;
        }
        SignatureStatus status = this.validationContext.allSignaturesNotExpired();
        boolean success = status.isEmpty();
        if (!success) {
            alertOnExpiredCertificate.alert((Object)status);
        }
    }
}

