/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.responsive;

import javafx.collections.ListChangeListener;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;

public class JFXResponsiveHandler {
    public static final PseudoClass PSEUDO_CLASS_EX_SMALL = PseudoClass.getPseudoClass((String)"extreme-small-device");
    public static final PseudoClass PSEUDO_CLASS_SMALL = PseudoClass.getPseudoClass((String)"small-device");
    public static final PseudoClass PSEUDO_CLASS_MEDIUM = PseudoClass.getPseudoClass((String)"medium-device");
    public static final PseudoClass PSEUDO_CLASS_LARGE = PseudoClass.getPseudoClass((String)"large-device");

    public JFXResponsiveHandler(Stage stage, PseudoClass pseudoClass) {
        this.scanAllNodes(stage.getScene().getRoot(), pseudoClass);
    }

    private void scanAllNodes(Parent parent, final PseudoClass pseudoClass) {
        parent.getChildrenUnmodifiable().addListener((ListChangeListener)new ListChangeListener<Node>(){

            public void onChanged(ListChangeListener.Change<? extends Node> c) {
                while (c.next()) {
                    if (c.wasPermutated() || c.wasUpdated()) continue;
                    for (Node addedNode : c.getAddedSubList()) {
                        if (!(addedNode instanceof Parent)) continue;
                        JFXResponsiveHandler.this.scanAllNodes((Parent)addedNode, pseudoClass);
                    }
                }
            }
        });
        for (Node component : parent.getChildrenUnmodifiable()) {
            if (component instanceof Pane) {
                ((Pane)component).getChildren().addListener((ListChangeListener)new ListChangeListener<Node>(){

                    public void onChanged(ListChangeListener.Change<? extends Node> c) {
                        while (c.next()) {
                            if (c.wasPermutated() || c.wasUpdated()) continue;
                            for (Node addedNode : c.getAddedSubList()) {
                                if (!(addedNode instanceof Parent)) continue;
                                JFXResponsiveHandler.this.scanAllNodes((Parent)addedNode, pseudoClass);
                            }
                        }
                    }
                });
                this.scanAllNodes((Parent)((Pane)component), pseudoClass);
                continue;
            }
            if (component instanceof ScrollPane) {
                ((ScrollPane)component).contentProperty().addListener((o, oldVal, newVal) -> this.scanAllNodes((Parent)newVal, pseudoClass));
                if (!(((ScrollPane)component).getContent() instanceof Parent)) continue;
                this.scanAllNodes((Parent)((ScrollPane)component).getContent(), pseudoClass);
                continue;
            }
            if (!(component instanceof Control)) continue;
            component.pseudoClassStateChanged(PSEUDO_CLASS_EX_SMALL, pseudoClass == PSEUDO_CLASS_EX_SMALL);
            component.pseudoClassStateChanged(PSEUDO_CLASS_SMALL, pseudoClass == PSEUDO_CLASS_SMALL);
            component.pseudoClassStateChanged(PSEUDO_CLASS_MEDIUM, pseudoClass == PSEUDO_CLASS_MEDIUM);
            component.pseudoClassStateChanged(PSEUDO_CLASS_LARGE, pseudoClass == PSEUDO_CLASS_LARGE);
        }
    }
}

