/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.core;

import io.datafx.core.DataFXConfiguration;
import io.datafx.core.ExceptionHandler$$Lambda$1;
import io.datafx.core.ExceptionHandler$$Lambda$2;
import io.datafx.core.ExceptionHandler$$Lambda$3;
import io.datafx.core.concurrent.ConcurrentUtils;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;

public class ExceptionHandler {
    private static final Logger LOGGER = Logger.getLogger(ExceptionHandler.class.getName());
    private static ChangeListener<Throwable> loggerListener;
    private static ExceptionHandler defaultInstance;
    private static boolean logException;
    private ObjectProperty<Throwable> exception;

    public static synchronized ExceptionHandler getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new ExceptionHandler();
            ExceptionHandler.setExceptionLogging(DataFXConfiguration.getInstance().isExceptionLoggingActive());
        }
        return defaultInstance;
    }

    public static ChangeListener<Throwable> getLoggerListener() {
        if (loggerListener == null) {
            loggerListener = ExceptionHandler$$Lambda$1.lambdaFactory$();
        }
        return loggerListener;
    }

    public static void setExceptionLogging(boolean log) {
        if (log) {
            ExceptionHandler.getDefaultInstance().exceptionProperty().addListener(ExceptionHandler.getLoggerListener());
        } else {
            ExceptionHandler.getDefaultInstance().exceptionProperty().removeListener(ExceptionHandler.getLoggerListener());
        }
        logException = log;
    }

    public static boolean isLogException() {
        return logException;
    }

    public Throwable getException() {
        return (Throwable)this.exceptionProperty().get();
    }

    public void setException(Throwable exception) {
        if (Platform.isFxApplicationThread()) {
            this.exceptionProperty().set((Object)exception);
        } else {
            try {
                ConcurrentUtils.runAndWait(ExceptionHandler$$Lambda$2.lambdaFactory$(this, exception));
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.log(Level.SEVERE, "Can't handle exception in JavaFX Application Thread!", e);
                LOGGER.log(Level.SEVERE, "Initial exception: ", exception);
            }
        }
    }

    public <T> void observeWorker(Worker<T> worker) {
        worker.exceptionProperty().addListener(ExceptionHandler$$Lambda$3.lambdaFactory$(this));
    }

    public ObjectProperty<Throwable> exceptionProperty() {
        if (this.exception == null) {
            this.exception = new SimpleObjectProperty();
        }
        return this.exception;
    }

    private /* synthetic */ void lambda$observeWorker$2(ObservableValue ob, Throwable ol, Throwable e) {
        this.setException(e);
    }

    private /* synthetic */ void lambda$setException$1(Throwable throwable) {
        this.exceptionProperty().set((Object)throwable);
    }

    private static /* synthetic */ void lambda$getLoggerListener$0(ObservableValue ob, Throwable o, Throwable e) {
        if (e != null) {
            if (e instanceof Exception) {
                LOGGER.log(Level.SEVERE, "DataFX Exception Handler", (Exception)e);
            } else {
                LOGGER.log(Level.SEVERE, "DataFX Exception Handler: " + e.getMessage());
            }
        }
    }

    static {
        logException = false;
    }

    static /* synthetic */ void access$lambda$0(ObservableValue observableValue, Throwable throwable, Throwable throwable2) {
        ExceptionHandler.lambda$getLoggerListener$0(observableValue, throwable, throwable2);
    }

    static /* synthetic */ void access$lambda$1(ExceptionHandler exceptionHandler, Throwable throwable) {
        exceptionHandler.lambda$setException$1(throwable);
    }

    static /* synthetic */ void access$lambda$2(ExceptionHandler exceptionHandler, ObservableValue observableValue, Throwable throwable, Throwable throwable2) {
        exceptionHandler.lambda$observeWorker$2(observableValue, throwable, throwable2);
    }
}

