/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs10.utils;

import com.anf.pkcs10.PKCS10Request;
import com.anf.pkcs10.PKCS10RequestFactory;
import com.anf.pkcs10.utils.ASN1Utils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class PKCS10Utils {
    private static Map<String, String> oldOUs = new TreeMap<String, String>();
    public static final Comparator<String> lowerCaseComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.toLowerCase().compareTo(o2.toLowerCase());
        }
    };

    public static String fixOldOUs(String oldOU) {
        String ou = oldOUs.get(oldOU);
        if (ou == null) {
            ou = oldOUs.get(oldOU.toLowerCase());
        }
        if (ou == null) {
            ou = oldOU;
        }
        return ou;
    }

    public static String matchAnyProfile(PKCS10Request request, String[] profiles) {
        RDN[] ous = request.getSubject().getRDNs(BCStyle.OU);
        String profile = null;
        for (int i = 0; profile == null && i < ous.length; ++i) {
            RDN ou = ous[i];
            profile = ASN1Utils.matchRDNValue(ou, (oid, val) -> {
                String profileFound = null;
                String value = PKCS10Utils.fixOldOUs(val.toString());
                String search = value.replace(" ", "_").trim();
                int index = Arrays.binarySearch(profiles, search, lowerCaseComparator);
                if (0 <= index) {
                    profileFound = profiles[index];
                }
                return profileFound;
            });
        }
        return profile;
    }

    public static RDN[] getOUFromPKCS10(PKCS10Request request) {
        RDN[] ous = request.getSubject().getRDNs(BCStyle.OU);
        return ous;
    }

    public static String extractStringField(X500Name subject, ASN1ObjectIdentifier oid) {
        RDN[] fields = subject.getRDNs(oid);
        if (fields != null && fields.length > 0 && fields[0].getFirst() != null) {
            return fields[0].getFirst().getValue().toString();
        }
        return null;
    }

    public static String getProfileOU(PKCS10Request request) {
        StringBuffer sb = new StringBuffer();
        RDN[] ous = request.getSubject().getRDNs(BCStyle.OU);
        if (ous != null && ous.length > 0) {
            sb.append((CharSequence)ASN1Utils.matchRDNValue(ous, (oid, ou) -> {
                String value = ou.toString();
                value = PKCS10Utils.fixOldOUs(value);
                return value;
            }));
        }
        return sb.toString();
    }

    public static String printOU(PKCS10Request request) {
        StringBuffer sb = new StringBuffer();
        RDN[] ous = request.getSubject().getRDNs(BCStyle.OU);
        if (ous != null && ous.length > 0) {
            for (int i = 0; i < ous.length; ++i) {
                sb.append("[" + ous[i].toString() + "] ");
            }
        }
        return sb.toString();
    }

    public static PublicKey extractPublicKey(PKCS10Request pkcs10) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, IOException {
        SubjectPublicKeyInfo publicKeyInfo = pkcs10.getSubjectPublicKeyInfo();
        KeyFactory factory = KeyFactory.getInstance("RSA", "BC");
        PublicKey publicKey = factory.generatePublic(new X509EncodedKeySpec(publicKeyInfo.getEncoded()));
        return publicKey;
    }

    public static PKCS10Request readFromBase64(InputStream input) throws IOException, IllegalArgumentException {
        return PKCS10Utils.readFromBase64(new InputStreamReader(input));
    }

    public static PKCS10Request readFromBase64(Reader input) throws IOException, IllegalArgumentException {
        String BASE64_COMMENT = "--";
        StringBuffer pkcs10Buffer = new StringBuffer();
        BufferedReader buffReader = new BufferedReader(input);
        String currentLine = buffReader.readLine();
        while (currentLine != null) {
            if (currentLine.indexOf("--") == -1) {
                pkcs10Buffer.append(currentLine);
            }
            currentLine = buffReader.readLine();
        }
        return PKCS10RequestFactory.createPKCS10(Base64.decode((byte[])pkcs10Buffer.toString().getBytes()));
    }

    public static PKCS10Request readFromBinary(InputStream input) throws IOException, IllegalArgumentException {
        ByteArrayOutputStream tempOutput = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)input, (OutputStream)tempOutput);
        byte[] byteContents = tempOutput.toByteArray();
        return PKCS10RequestFactory.createPKCS10(byteContents);
    }

    public static void writeToBinary(PKCS10Request request, OutputStream output) throws IOException {
        byte[] byteContents = request.getEncoded();
        ByteArrayInputStream tempInput = new ByteArrayInputStream(byteContents);
        IOUtils.copy((InputStream)tempInput, (OutputStream)output);
    }

    public static PKCS10Request loadPKCS10(String csr) throws IOException {
        PKCS10Request pkcs10;
        try (PemReader reader = new PemReader((Reader)new StringReader(csr));){
            PemObject obj = reader.readPemObject();
            pkcs10 = PKCS10RequestFactory.createPKCS10(obj.getContent());
        }
        return pkcs10;
    }

    public static byte[] getBytesPKCS10(String csr) throws IOException {
        byte[] pkcs10;
        try (PemReader reader = new PemReader((Reader)new StringReader(csr));){
            PemObject obj = reader.readPemObject();
            pkcs10 = obj.getContent();
        }
        return pkcs10;
    }

    public static byte[] getPKCS10AttributeExtensionValue(PKCS10Request csr, ASN1ObjectIdentifier oid) {
        Extension ext = PKCS10Utils.getPKCS10AttributeExtension(csr, oid);
        if (ext != null) {
            return ext.getExtnValue().getOctets();
        }
        return null;
    }

    public static Extension getPKCS10AttributeExtension(PKCS10Request csr, ASN1ObjectIdentifier oid) {
        Attribute[] attributes = csr.getAttributes();
        if (attributes != null && attributes.length > 0) {
            for (int i = 0; i < attributes.length; ++i) {
                Attribute atr = attributes[i];
                ASN1ObjectIdentifier type = atr.getAttrType();
                ASN1Set set = atr.getAttrValues();
                if (!type.equals((ASN1Primitive)PKCSObjectIdentifiers.pkcs_9_at_extensionRequest)) continue;
                Enumeration objects = set.getObjects();
                while (objects.hasMoreElements()) {
                    ASN1Encodable obj = (ASN1Encodable)objects.nextElement();
                    if (!(obj instanceof ASN1Sequence)) continue;
                    Extensions extensions = Extensions.getInstance((Object)obj);
                    Extension ext = extensions.getExtension(oid);
                    return ext;
                }
            }
        }
        return null;
    }

    public static Extensions getExtensions(PKCS10Request pkcs10) {
        return pkcs10.getExtensions();
    }

    public static Set<String> getPolicyOids(PKCS10Request pkcs10) {
        TreeSet<String> oids = null;
        Extensions extensions = pkcs10.getExtensions();
        if (extensions != null) {
            ASN1ObjectIdentifier[] extensionOIDs;
            oids = new TreeSet<String>();
            for (ASN1ObjectIdentifier oid : extensionOIDs = extensions.getExtensionOIDs()) {
                if (!oid.equals((ASN1Primitive)Extension.certificatePolicies)) continue;
                Extension ext = extensions.getExtension(oid);
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)ext.getExtnValue().getOctets());
                Enumeration objects = seq.getObjects();
                while (objects.hasMoreElements()) {
                    ASN1Sequence subseq;
                    ASN1Encodable object = (ASN1Encodable)objects.nextElement();
                    if (!(object instanceof ASN1Sequence) || (subseq = (ASN1Sequence)object).size() < 1 || !(subseq.getObjectAt(0) instanceof ASN1ObjectIdentifier)) continue;
                    ASN1ObjectIdentifier policyOid = (ASN1ObjectIdentifier)subseq.getObjectAt(0);
                    oids.add(policyOid.getId());
                }
            }
        }
        return oids;
    }
}

