/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs10.utils;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

public class ASN1Utils {
    private static final Logger log = LogManager.getLogger(ASN1Utils.class);

    public static String getSubjectFieldAsString(X509Certificate cert, ASN1ObjectIdentifier fieldOid) throws CertificateEncodingException {
        X500Name x500name = new JcaX509CertificateHolder(cert).getSubject();
        return ASN1Utils.getValue(fieldOid, x500name);
    }

    public static String getValue(ASN1ObjectIdentifier fieldOid, X500Name x500name) {
        return ASN1Utils.matchRDNValue(x500name.getRDNs(), (ASN1ObjectIdentifier oid, ASN1Encodable value) -> {
            String res = null;
            if (oid.equals((ASN1Primitive)fieldOid)) {
                res = value.toString();
            }
            return res;
        });
    }

    public static <R> R matchRDNValue(RDN[] fields, BiFunction<ASN1ObjectIdentifier, ASN1Encodable, R> action) {
        R result = null;
        for (int i = 0; result == null && i < fields.length; ++i) {
            result = ASN1Utils.matchRDNValue(fields[i], action);
        }
        return result;
    }

    public static <R> R matchRDNValue(RDN field, BiFunction<ASN1ObjectIdentifier, ASN1Encodable, R> action) {
        R result = null;
        AttributeTypeAndValue[] typesAndValues = field.getTypesAndValues();
        for (int v = 0; result == null && v < typesAndValues.length; ++v) {
            AttributeTypeAndValue attributeTypeAndValue = typesAndValues[v];
            ASN1ObjectIdentifier oid = attributeTypeAndValue.getType();
            ASN1Encodable value = attributeTypeAndValue.getValue();
            result = action.apply(oid, value);
        }
        return result;
    }

    public static String valorOidFromAtributes(ASN1Set attributes, String oid) {
        Enumeration extensions;
        String result = null;
        Enumeration enumeration = extensions = attributes == null ? new Vector().elements() : attributes.getObjects();
        while (extensions.hasMoreElements()) {
            try {
                ASN1Sequence currSequence = (ASN1Sequence)extensions.nextElement();
                Enumeration currAttrEnum = currSequence.getObjects();
                ASN1ObjectIdentifier attrOID = (ASN1ObjectIdentifier)currAttrEnum.nextElement();
                ASN1Encodable attrValue = (ASN1Encodable)currAttrEnum.nextElement();
                if (!oid.equals(attrOID.getId())) continue;
                return attrValue.toString();
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
        }
        return result;
    }
}

