/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs10.impl;

import com.anf.pkcs10.PKCS10Creator;
import com.anf.pkcs10.exception.PKCS10CreationException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public class PKCS10CreatorV2
implements PKCS10Creator {
    @Override
    public byte[] createPKCS10(ASN1Set attributes, String signAlg, X500Principal subjectX500Principal, PublicKey publicKey, String provider, PrivateKey privateKey) {
        return this.createPKCS10(attributes, signAlg, subjectX500Principal, publicKey, Security.getProvider(provider), privateKey);
    }

    @Override
    public byte[] createPKCS10(ASN1Set attributes, String signAlg, X500Principal subjectX500Principal, PublicKey publicKey, Provider provider, PrivateKey privateKey) {
        try {
            JcaPKCS10CertificationRequestBuilder builder = new JcaPKCS10CertificationRequestBuilder(subjectX500Principal, publicKey);
            attributes.forEach(attr -> {
                try {
                    byte[] atrEncode = attr.toASN1Primitive().getEncoded();
                    ASN1Sequence seq = ASN1Sequence.getInstance((Object)atrEncode);
                    ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)seq.getObjectAt(0);
                    ASN1Encodable value = seq.getObjectAt(1);
                    builder.addAttribute(oid, value);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            PKCS10CertificationRequest csr = builder.build(new JcaContentSignerBuilder(signAlg).setProvider(provider).build(privateKey));
            return csr.getEncoded();
        }
        catch (Throwable e) {
            throw new PKCS10CreationException(e);
        }
    }
}

