/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs10.impl;

import com.anf.pkcs10.PKCS10Request;
import com.anf.pkcs10.exception.PKCS10CreationException;
import com.anf.pkcs10.exception.PKCS10EncodingException;
import com.anf.pkcs10.exception.PKCS10PublicKeyException;
import com.anf.pkcs10.exception.PKCS10SignatureException;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCSException;

public class PKCS10CertificateRequestNewImpl
implements PKCS10Request {
    private PKCS10CertificationRequest request;

    public PKCS10CertificateRequestNewImpl(byte[] encoded) {
        try {
            this.request = new PKCS10CertificationRequest(encoded);
        }
        catch (IOException e) {
            throw new PKCS10CreationException(e);
        }
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            SubjectPublicKeyInfo publicKeyInfo = this.request.getSubjectPublicKeyInfo();
            KeyFactory factory = KeyFactory.getInstance("RSA", "BC");
            PublicKey publicKey = factory.generatePublic(new X509EncodedKeySpec(publicKeyInfo.getEncoded()));
            return publicKey;
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new PKCS10PublicKeyException(e);
        }
    }

    @Override
    public byte[] getEncoded() {
        try {
            return this.request.getEncoded();
        }
        catch (IOException e) {
            throw new PKCS10EncodingException(e);
        }
    }

    @Override
    public X500Name getSubject() {
        return this.request.getSubject();
    }

    @Override
    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.request.getSubjectPublicKeyInfo();
    }

    @Override
    public Attribute[] getAttributes() {
        return this.request.getAttributes();
    }

    @Override
    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.request.getSignatureAlgorithm();
    }

    @Override
    public ASN1Set getAttributesSet() {
        return this.request.toASN1Structure().getCertificationRequestInfo().getAttributes();
    }

    @Override
    public boolean verifySignature() {
        try {
            return this.request.isSignatureValid(new JcaContentVerifierProviderBuilder().build(this.getPublicKey()));
        }
        catch (OperatorCreationException | PKCSException e) {
            throw new PKCS10SignatureException(e);
        }
    }

    @Override
    public Extensions getExtensions() {
        ASN1Encodable encodableSet;
        ASN1Encodable oid;
        ASN1Sequence attrSeq;
        Enumeration seqObjects;
        ASN1Set attributesSet = this.getAttributesSet();
        if (attributesSet != null && attributesSet.getObjects().hasMoreElements() && (seqObjects = (attrSeq = (ASN1Sequence)attributesSet.getObjectAt(0)).getObjects()).hasMoreElements() && (oid = (ASN1Encodable)seqObjects.nextElement()) instanceof ASN1ObjectIdentifier && ((ASN1ObjectIdentifier)oid).getId().equals("1.2.840.113549.1.9.14") && seqObjects.hasMoreElements() && (encodableSet = (ASN1Encodable)seqObjects.nextElement()) instanceof ASN1Set && ((ASN1Set)encodableSet).getObjects().hasMoreElements()) {
            ASN1Encodable encSeq = ((ASN1Set)encodableSet).getObjectAt(0);
            try {
                Extensions exts = Extensions.getInstance((Object)encSeq);
                return exts;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

