/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs10.custom;

import com.anf.pkcs10.custom.CustomAbstractCertificationRequestInfo;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Name;

public class CustomCertificationRequestInfo
extends CustomAbstractCertificationRequestInfo {
    ASN1Integer version = new ASN1Integer(0L);
    X509Name subject;
    SubjectPublicKeyInfo subjectPKInfo;
    ASN1Set attributes = null;

    public CustomCertificationRequestInfo(X509Name subject, SubjectPublicKeyInfo pkInfo, ASN1Set attributes) {
        super(subject, pkInfo, CustomCertificationRequestInfo.transformAttributes(attributes));
        this.subject = subject;
        this.subjectPKInfo = pkInfo;
        this.attributes = attributes;
    }

    private static ASN1Set transformAttributes(ASN1Set attrs) {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        attrs.forEach(attr -> {
            try {
                ASN1Sequence sequence = ASN1Sequence.getInstance((Object)attr.toASN1Primitive().getEncoded());
                Attribute newAtr = new Attribute((ASN1ObjectIdentifier)sequence.getObjectAt(0), (ASN1Set)new DERSet(sequence.getObjectAt(1)));
                vector.add((ASN1Encodable)newAtr);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        DERSet set = new DERSet(vector);
        return set;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.version);
        v.add((ASN1Encodable)this.subject);
        v.add((ASN1Encodable)this.subjectPKInfo);
        if (this.attributes != null) {
            v.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.attributes));
        }
        return new DERSequence(v);
    }
}

