/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs10.custom;

import com.anf.pkcs10.custom.CustomAbstractCertificationRequestInfo;
import com.anf.pkcs10.custom.CustomCertificationRequestInfo;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class CustomCertificationRequest
extends ASN1Object {
    protected CustomAbstractCertificationRequestInfo reqInfo = null;
    protected AlgorithmIdentifier sigAlgId = null;
    protected DERBitString sigBits = null;

    public static CustomCertificationRequest getInstance(Object o) {
        if (o instanceof CustomCertificationRequest) {
            return (CustomCertificationRequest)((Object)o);
        }
        if (o != null) {
            return new CustomCertificationRequest(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    protected CustomCertificationRequest() {
    }

    public CustomCertificationRequest(CustomCertificationRequestInfo requestInfo, AlgorithmIdentifier algorithm, DERBitString signature) {
        this.reqInfo = requestInfo;
        this.sigAlgId = algorithm;
        this.sigBits = signature;
    }

    public CustomCertificationRequest(ASN1Sequence seq) {
        this.reqInfo = CustomCertificationRequestInfo.getInstance(seq.getObjectAt(0));
        this.sigAlgId = AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(1));
        this.sigBits = (DERBitString)seq.getObjectAt(2);
    }

    public CustomAbstractCertificationRequestInfo getCertificationRequestInfo() {
        return this.reqInfo;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.sigAlgId;
    }

    public DERBitString getSignature() {
        return this.sigBits;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.reqInfo);
        v.add((ASN1Encodable)this.sigAlgId);
        v.add((ASN1Encodable)this.sigBits);
        return new DERSequence(v);
    }
}

