/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs10.custom;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Name;

public class CustomAbstractCertificationRequestInfo
extends ASN1Object {
    ASN1Integer version = new ASN1Integer(0L);
    X500Name subject;
    SubjectPublicKeyInfo subjectPKInfo;
    ASN1Set attributes = null;

    public static CustomAbstractCertificationRequestInfo getInstance(Object obj) {
        if (obj instanceof CustomAbstractCertificationRequestInfo) {
            return (CustomAbstractCertificationRequestInfo)((Object)obj);
        }
        if (obj != null) {
            return new CustomAbstractCertificationRequestInfo(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    public CustomAbstractCertificationRequestInfo(X500Name subject, SubjectPublicKeyInfo pkInfo, ASN1Set attributes) {
        if (subject == null || pkInfo == null) {
            throw new IllegalArgumentException("Not all mandatory fields set in CertificationRequestInfo generator.");
        }
        CustomAbstractCertificationRequestInfo.validateAttributes(attributes);
        this.subject = subject;
        this.subjectPKInfo = pkInfo;
        this.attributes = attributes;
    }

    public CustomAbstractCertificationRequestInfo(X509Name subject, SubjectPublicKeyInfo pkInfo, ASN1Set attributes) {
        this(X500Name.getInstance((Object)subject.toASN1Primitive()), pkInfo, attributes);
    }

    public CustomAbstractCertificationRequestInfo(ASN1Sequence seq) {
        this.version = (ASN1Integer)seq.getObjectAt(0);
        this.subject = X500Name.getInstance((Object)seq.getObjectAt(1));
        this.subjectPKInfo = SubjectPublicKeyInfo.getInstance((Object)seq.getObjectAt(2));
        if (seq.size() > 3) {
            ASN1TaggedObject tagobj = (ASN1TaggedObject)seq.getObjectAt(3);
            this.attributes = ASN1Set.getInstance((ASN1TaggedObject)tagobj, (boolean)false);
        }
        CustomAbstractCertificationRequestInfo.validateAttributes(this.attributes);
        if (this.subject == null || this.version == null || this.subjectPKInfo == null) {
            throw new IllegalArgumentException("Not all mandatory fields set in CertificationRequestInfo generator.");
        }
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPKInfo;
    }

    public ASN1Set getAttributes() {
        return this.attributes;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.version);
        v.add((ASN1Encodable)this.subject);
        v.add((ASN1Encodable)this.subjectPKInfo);
        if (this.attributes != null) {
            v.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.attributes));
        }
        return new DERSequence(v);
    }

    private static void validateAttributes(ASN1Set attributes) {
        if (attributes == null) {
            return;
        }
    }
}

