/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.signature;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.spi.DSSUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureValueChecker {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureValueChecker.class);

    public SignatureValue ensureSignatureValue(SignatureValue signatureValue, SignatureAlgorithm targetSignatureAlgorithm) {
        DigestAlgorithm signatureDigestAlgorithm;
        Objects.requireNonNull(targetSignatureAlgorithm, "The target SignatureAlgorithm shall be defined within SignatureParameters!");
        if (signatureValue == null) {
            LOG.debug("The SignatureValue is not provided. Cannot verify the value.");
            return null;
        }
        if (targetSignatureAlgorithm.equals((Object)signatureValue.getAlgorithm())) {
            LOG.debug("The created SignatureValue matches the defined target SignatureAlgorithm : '{}'", (Object)targetSignatureAlgorithm);
            return signatureValue;
        }
        DigestAlgorithm targetDigestAlgorithm = targetSignatureAlgorithm.getDigestAlgorithm();
        DigestAlgorithm digestAlgorithm = signatureDigestAlgorithm = signatureValue.getAlgorithm() != null ? signatureValue.getAlgorithm().getDigestAlgorithm() : null;
        if (!targetDigestAlgorithm.equals((Object)signatureDigestAlgorithm)) {
            throw new DSSException(String.format("The DigestAlgorithm within the SignatureValue '%s' does not match the expected value : '%s'", signatureDigestAlgorithm, targetDigestAlgorithm));
        }
        if (EncryptionAlgorithm.ECDSA.isEquivalent(targetSignatureAlgorithm.getEncryptionAlgorithm())) {
            SignatureValue newSignatureValue = DSSUtils.convertECSignatureValue((SignatureAlgorithm)targetSignatureAlgorithm, (SignatureValue)signatureValue);
            LOG.info("The algorithm '{}' has been obtained from the SignatureValue. The SignatureValue converted to the expected algorithm '{}'.", (Object)signatureValue.getAlgorithm(), (Object)targetSignatureAlgorithm);
            return newSignatureValue;
        }
        throw new DSSException(String.format("The SignatureAlgorithm within the SignatureValue '%s' does not match the expected value : '%s'. Conversion is not supported!", signatureValue.getAlgorithm(), targetSignatureAlgorithm));
    }
}

