/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.signature;

import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.utils.Utils;

public class FileNameBuilder {
    private static final String CONTAINER_PREFIX = "container";
    private static final String DOCUMENT_PREFIX = "document";
    private static final String SIGNED_SUFFIX = "-signed";
    private static final String COUNTER_SIGNED_SUFFIX = "-counter-signed";
    private static final String TIMESTAMPED_SUFFIX = "-timestamped";
    private static final String EXTENDED_SUFFIX = "-extended";
    private static final String SIGNATURE_POLICY_STORE_SUFFIX = "-sig-policy-store";
    private static final String P7M_EXTENSION = "p7m";
    private static final String P7S_EXTENSION = "p7s";
    private String originalFilename;
    private SigningOperation signingOperation;
    private SignatureLevel signatureLevel;
    private SignaturePackaging signaturePackaging;
    private MimeType mimeType;

    public FileNameBuilder setOriginalFilename(String originalFilename) {
        this.originalFilename = originalFilename;
        return this;
    }

    public FileNameBuilder setSigningOperation(SigningOperation signingOperation) {
        this.signingOperation = signingOperation;
        return this;
    }

    public FileNameBuilder setSignatureLevel(SignatureLevel signatureLevel) {
        this.signatureLevel = signatureLevel;
        return this;
    }

    public FileNameBuilder setSignaturePackaging(SignaturePackaging signaturePackaging) {
        this.signaturePackaging = signaturePackaging;
        return this;
    }

    public FileNameBuilder setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public String build() {
        String extension;
        StringBuilder finalName = new StringBuilder();
        String originalName = this.isContainerMimeType(this.mimeType) ? CONTAINER_PREFIX : this.originalFilename;
        String originalExtension = "";
        if (Utils.isStringNotEmpty((String)originalName)) {
            originalExtension = Utils.getFileNameExtension((String)originalName);
            if (Utils.isStringNotEmpty((String)originalExtension)) {
                originalName = originalName.substring(0, originalName.length() - originalExtension.length() - 1);
            }
            finalName.append(originalName);
        } else {
            finalName.append(DOCUMENT_PREFIX);
        }
        if (this.signingOperation != null) {
            switch (this.signingOperation) {
                case SIGN: {
                    finalName.append(SIGNED_SUFFIX);
                    break;
                }
                case COUNTER_SIGN: {
                    finalName.append(COUNTER_SIGNED_SUFFIX);
                    break;
                }
                case TIMESTAMP: {
                    finalName.append(TIMESTAMPED_SUFFIX);
                    break;
                }
                case EXTEND: {
                    finalName.append(EXTENDED_SUFFIX);
                    break;
                }
                case ADD_SIG_POLICY_STORE: {
                    finalName.append(SIGNATURE_POLICY_STORE_SUFFIX);
                    break;
                }
                default: {
                    throw new DSSException(String.format("The following operation '%s' is not supported!", new Object[]{this.signingOperation}));
                }
            }
        }
        if (this.signatureLevel != null) {
            finalName.append('-');
            finalName.append(Utils.lowerCase((String)this.signatureLevel.name().replace("_", "-")));
        }
        String string = extension = Utils.isStringNotBlank((String)(extension = this.getFileExtensionString(this.signatureLevel, this.signaturePackaging, this.mimeType))) ? extension : originalExtension;
        if (Utils.isStringNotBlank((String)extension)) {
            finalName.append('.');
            finalName.append(extension);
        }
        return finalName.toString();
    }

    private boolean isContainerMimeType(MimeType mimeType) {
        return MimeTypeEnum.ASICS.equals((Object)mimeType) || MimeTypeEnum.ASICE.equals((Object)mimeType);
    }

    private String getFileExtensionString(SignatureLevel level, SignaturePackaging packaging, MimeType mimeType) {
        if (mimeType != null) {
            return mimeType.getExtension();
        }
        if (level != null) {
            SignatureForm signatureForm = level.getSignatureForm();
            switch (signatureForm) {
                case XAdES: {
                    return MimeTypeEnum.XML.getExtension();
                }
                case CAdES: {
                    if (packaging == null) break;
                    return SignaturePackaging.DETACHED.equals((Object)packaging) ? P7S_EXTENSION : P7M_EXTENSION;
                }
                case PAdES: {
                    return MimeTypeEnum.PDF.getExtension();
                }
                case JAdES: {
                    return MimeTypeEnum.JSON.getExtension();
                }
                default: {
                    throw new DSSException(String.format("Unable to generate a full document name! The SignatureForm %s is not supported.", signatureForm));
                }
            }
        }
        return "";
    }
}

