package com.anf.gestion.client.files.model;

import java.text.SimpleDateFormat;
import java.util.Date;

public class WebFile {
	

	private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
	
    private Long id;

 
    private String name;
   
    private String extension;
 
    private String path;
 
    private String localizator;

    private DocumentType docType;
    
    private Date creationDate;
    
    private String created=null;
    
    public WebFile() {
	}

	public WebFile(String name, String extension, String path, String localizator, DocumentType docType,
			Date creationDate) {
		super();
		this.name = name;
		this.extension = extension;
		this.path = path;
		this.localizator = localizator;
		this.docType = docType;
		this.creationDate = creationDate;
	}
	
	public String getCreated() {
		return created;
	}
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getExtension() {
		return extension;
	}

	public void setExtension(String extension) {
		this.extension = extension;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public String getLocalizator() {
		return localizator;
	}

	public void setLocalizator(String localizator) {
		this.localizator = localizator;
	}

	public DocumentType getDocType() {
		return docType;
	}

	public void setDocType(DocumentType docType) {
		this.docType = docType;
	}

	public Date getCreationDate() {
		return creationDate;
	}

	public void setCreationDate(Date creationDate) {
		this.creationDate = creationDate;
	}
	
	public void setCreated() {
		this.created = dateFormat.format(creationDate);
	}
    
    

    
    

}
