package com.anf.ws.ar.zip;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.anf.oauth.client.AbstractClient;

public class ARZipFileUploader extends AbstractClient{
	
	private static final Logger log = LogManager.getLogger(ARZipFileUploader.class);

	private static final String DEFAULT_URL ="https://gestiones.anf.es/request/registry";
	
	public ARZipFileUploader() {
		super(DEFAULT_URL,30000);
	}	

	public ARZipFileUploader(String url) {
		super(url,30000);
	}

	public boolean upload(File fileToUpload, Integer validity, boolean requiresValidation)
			throws IOException{
		
		Map<String, String> headers=new TreeMap<>();
		headers.put("Content-Type", "application/zip");
		headers.put("Transfer-Encoding", "chunked");
		headers.put("validity", String.valueOf(validity));
		headers.put("validation", String.valueOf(requiresValidation));
		byte[] resp = handleRawRequest("", "POST", FileUtils.readFileToByteArray(fileToUpload), headers);

		String result = new String(resp);
		log.info("result of uploading registry request zip: {}",result);
		return result.equals("<OK/>");
	}
}