package com.anf.ws.ar.xml.types;

import com.anf.ws.ar.enums.ProfileType;
import com.anf.ws.ar.enums.TypeCert;

public class TypeCertConverter {

	protected CertificateType type;	

	public TypeCertConverter(CertificateType type) {
		super();
		this.type = type;
	}

	public TypeCert convertType(ProfileType profileType) {

		switch (profileType) {
		case KeyDist, Software, Centralized, QSCD:return signProfile(type);
		case Auth:return authProfile(type);
		case Cipher:return cipherProfile(type);
		default:
			return null;
		}
	}

	private TypeCert signProfile(CertificateType type) {
		switch (type) {
		case PERSONA_FISICA,PERSONA_NATURAL_EC,REP_LEGAL_EC,SELLO_ELECTRONICO_EC,MIEMBRO_EMPRESA_EC: return TypeCert.pfisfirma;
		case PERSONA_FISICA_CORP,CORPORATIVO_COLEGIADO: return TypeCert.pfiscorpfirma;
		case OPERADOR_AR, OPERADOR_AR_2:return TypeCert.arfirma;
		case RDE: return TypeCert.rdefirma;
		case REP_LEGAL_PJ: return TypeCert.replegalpjfirma;
		case REP_LEGAL_SIN_PJ: return TypeCert.replegalentsinpjfirma;
		case REP_LEGAL_ADMIN_UNICOS: return TypeCert.replegalentsinpjfirma;
		case EMPLEADO_PUBLICO_MEDIO: return TypeCert.publicomedio;
		case EMPLEADO_PUBLICO_ALTO: return TypeCert.publicofirmaalto;
		case OPERADOR_PKI_ADMIN, OPERADOR_PKI: return TypeCert.operadorfirma;
		case QSEALC,QSEALC_AP_MEDIO,QSEALC_AP_ALTO,QSEALC_PSD2: return TypeCert.selloelec;
		}
		return null;
	}
	
	private TypeCert authProfile(CertificateType type) {
		switch (type) {
		case PERSONA_FISICA,PERSONA_FISICA_CORP,CORPORATIVO_COLEGIADO,PERSONA_NATURAL_EC,REP_LEGAL_EC,SELLO_ELECTRONICO_EC,MIEMBRO_EMPRESA_EC: return TypeCert.pfisaut;
		case OPERADOR_AR, OPERADOR_AR_2:return TypeCert.araut;
		case RDE: return TypeCert.rdeaut;
		case REP_LEGAL_PJ: return TypeCert.replegalpjaut;
		case REP_LEGAL_SIN_PJ: return TypeCert.replegalentsinpjaut;
		case REP_LEGAL_ADMIN_UNICOS: return TypeCert.replegalentsinpjaut;
		case EMPLEADO_PUBLICO_MEDIO: return TypeCert.publicomedio;
		case EMPLEADO_PUBLICO_ALTO: return TypeCert.publicoautalto;
		case OPERADOR_PKI_ADMIN, OPERADOR_PKI: return TypeCert.operadoraut;
		case QSEALC,QSEALC_AP_MEDIO,QSEALC_AP_ALTO,QSEALC_PSD2: return TypeCert.selloelec;
		}
		return null;
	}

	private TypeCert cipherProfile(CertificateType type) {
		switch (type) {
		case PERSONA_FISICA,PERSONA_FISICA_CORP,CORPORATIVO_COLEGIADO,PERSONA_NATURAL_EC,REP_LEGAL_EC,SELLO_ELECTRONICO_EC,MIEMBRO_EMPRESA_EC: return TypeCert.pfiscifrado;
		case OPERADOR_AR, OPERADOR_AR_2:return TypeCert.arcifrado;
		case RDE: return TypeCert.rdecifrado;
		case REP_LEGAL_PJ: return TypeCert.replegalpjcifrado;
		case REP_LEGAL_SIN_PJ: return TypeCert.replegalentsinpjcifrado;
		case REP_LEGAL_ADMIN_UNICOS: return TypeCert.replegalentsinpjcifrado;
		case EMPLEADO_PUBLICO_MEDIO: return TypeCert.publicomedio;
		case EMPLEADO_PUBLICO_ALTO: return TypeCert.publicocifradoalto;
		case OPERADOR_PKI_ADMIN, OPERADOR_PKI: return TypeCert.operadorcifrado;
		case QSEALC,QSEALC_AP_MEDIO,QSEALC_AP_ALTO,QSEALC_PSD2: return TypeCert.selloelec;			
		}
		return null;
	}
}
