package com.anf.ws.ar.xml.subjaltnames.impl;

import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.x500.style.BCStyle;

import com.anf.cryptotoken.oid.PolicyOID;
import com.anf.oauth.json.JSONFactory;
import com.anf.ra.xml.ApplicationForm.Applicant.Attributes.Attribute;
import com.anf.ws.ar.enums.IdentificationType;
import com.anf.ws.ar.xml.model.SubjectAlternateName;
import com.anf.ws.ar.xml.service.params.XmlBuildParams;

public class SignSubjAltNames extends BasicSubjAltNames{
	
	private static final Logger log = LogManager.getLogger(SignSubjAltNames.class);

	public SignSubjAltNames(XmlBuildParams params, PolicyOID policy, List<Attribute> attributes) {
		super(params,policy,attributes);
	}

	@Override
	public List<SubjectAlternateName> build() {
		List<SubjectAlternateName> list=super.build();

		String root=policy.policyRoot().getId();

		if (params.isSanIncludeCNAndSerial()) {
			log.info("adding CN and serial in SAN");
			String serial = attribute(BCStyle.SERIALNUMBER.getId());
			if (serial != null)
				addSubjectAlternateNameOid(list, BCStyle.SERIALNUMBER.getId(), serial.toUpperCase());
			String cn = attribute(BCStyle.CN.getId());
			if (cn != null)
				addSubjectAlternateNameOid(list, BCStyle.CN.getId(), cn.toUpperCase());
		}
		
		String name = attribute(BCStyle.GIVENNAME.getId());
		if(name!=null)
			addSubjectAlternateNameOid(list, root+".10.1", name.toUpperCase());

		String surname = attribute(BCStyle.SURNAME.getId());
		String[] split=null;
		if(surname!=null)
			split=surname.trim().split(" ");
		lastName1=oidMap.get("10.2");
		if(lastName1==null && split!=null && split.length>0)
			lastName1=split[0];
		if(lastName1!=null)
			addSubjectAlternateNameOid(list, root+".10.2", lastName1.toUpperCase());

		lastName2=oidMap.get("10.3");
		if(lastName2==null && split!=null && split.length>1)
			lastName2=split[1];
		if(lastName2!=null)
			addSubjectAlternateNameOid(list, root+".10.3", lastName2.toUpperCase());

		String nif = attribute(BCStyle.SERIALNUMBER.getId());
		if(nif!=null) {
			String country=attribute(BCStyle.C.getId());
			nif=nif.replace("IDCES-","").replace("IDC"+country+"-", "").replace("IDC"+country, "").replace("-", "");
			nif=nif.trim();
		}
		if(nif!=null)			
			addSubjectAlternateNameOid(list, root+".10.4", nif.toUpperCase());

		String powerDocUrl=oidMap.get("10.10.1");
		addSubjectAlternateNameOid(list, root+".10.10.1", powerDocUrl);

		addSubjectAlternateNameOid(list, IdentificationType.OID, identificationType.value());

		if(log.isInfoEnabled())
			log.info("SAN list: {}",JSONFactory.buildJSON(list));
		return list;
	}


	@Override
	protected void addSubjectAlternateNameOid(List<SubjectAlternateName> list, String oid, String value) {
		SubjectAlternateName subjectAlternateName = null;
		if(value!=null && !value.isEmpty()) {
			subjectAlternateName=new SubjectAlternateName(oid,value.trim());
			list.add(subjectAlternateName);
		}
	}
}
