package com.anf.ws.ar.xml.subjaltnames.impl;

import java.util.List;

import org.bouncycastle.asn1.x500.style.BCStyle;

import com.anf.cryptotoken.oid.PolicyOID;
import com.anf.ra.xml.ApplicationForm.Applicant.Attributes.Attribute;
import com.anf.ws.ar.xml.model.SubjectAlternateName;
import com.anf.ws.ar.xml.service.params.XmlBuildParams;
import com.anf.ws.ar.xml.types.CertificateType;

public class EmpleadoSubjAltNames extends BasicSubjAltNames {

	private CertificateType certType;
	
	public EmpleadoSubjAltNames(XmlBuildParams params, PolicyOID policy,CertificateType certType, List<Attribute> attributes) {
		super(params, policy, attributes);
		this.certType=certType;
	}

	@Override
	public List<SubjectAlternateName> build() {
		List<SubjectAlternateName> list = super.build();

		int suffix=certType==CertificateType.EMPLEADO_PUBLICO_MEDIO?2:1;
		String oid="2.16.724.1.3.5.7."+suffix;
		String profile=((certType==CertificateType.EMPLEADO_PUBLICO_MEDIO)?
				"CERTIFICADO ELECTRONICO DE EMPLEADO PUBLICO (de nivel medio)":
				"CERTIFICADO CUALIFICADO DE FIRMA DE EMPLEADO PUBLICO DE NIVEL ALTO");
		addSubjectAlternateNameOid(list, oid+".1", profile);
		String org = attribute(BCStyle.O.getId());
		addSubjectAlternateNameOid(list, oid+".2", org);

		String cif = attribute("2.5.4.97");
		addSubjectAlternateNameOid(list, oid+".3", cif);

		String nif = attribute(BCStyle.SERIALNUMBER.getId());
		addSubjectAlternateNameOid(list, oid+".4", nif);

		addSubjectAlternateNameOid(list, oid+".5", params.getIdentNumber());

		String name = attribute(BCStyle.GIVENNAME.getId());
		addSubjectAlternateNameOid(list, oid+".6", name);

		addSubjectAlternateNameOid(list, oid+".7", lastName1);
		addSubjectAlternateNameOid(list, oid+".8", lastName2);

		String email = attribute(BCStyle.EmailAddress.getId());
		addSubjectAlternateNameOid(list, oid+".9", email);

		addSubjectAlternateNameOid(list, oid+".10", params.getOrgDepartment());

		String title = attribute(BCStyle.T.getId());
		addSubjectAlternateNameOid(list, oid+".11", title);
		
		return list;
	}
	
}
