package com.anf.ws.ar.xml.subjaltnames;

import java.util.List;

import com.anf.cryptotoken.oid.PolicyOID;
import com.anf.ra.xml.ApplicationForm.Applicant.Attributes.Attribute;
import com.anf.ws.ar.xml.service.params.XmlBuildParams;
import com.anf.ws.ar.xml.subjaltnames.impl.BasicSubjAltNames;
import com.anf.ws.ar.xml.subjaltnames.impl.EmpleadoSubjAltNames;
import com.anf.ws.ar.xml.subjaltnames.impl.QSealAPSubjAltNames;
import com.anf.ws.ar.xml.subjaltnames.impl.QSealSubjAltNames;
import com.anf.ws.ar.xml.subjaltnames.impl.SignSubjAltNames;
import com.anf.ws.ar.xml.types.CertificateType;

public interface SubjAltNamesFactory {

	public static SubjAltNames getSubjAltNames(CertificateType certType, XmlBuildParams params, PolicyOID policy, List<Attribute> attributes) {
		if(certType.match(CertificateType.PERSONA_NATURAL_EC,CertificateType.MIEMBRO_EMPRESA_EC,CertificateType.REP_LEGAL_EC,CertificateType.SELLO_ELECTRONICO_EC))
			return new BasicSubjAltNames(params, policy, attributes);
		
		if(certType==CertificateType.EMPLEADO_PUBLICO_MEDIO || certType==CertificateType.EMPLEADO_PUBLICO_ALTO)
			return new EmpleadoSubjAltNames(params, policy,certType, attributes);
		else if(certType.isSeal()) {
			if(certType==CertificateType.QSEALC || certType==CertificateType.QSEALC_PSD2)
				return new QSealSubjAltNames(params, policy, attributes);	
			return new QSealAPSubjAltNames(params, policy, attributes);
		}else
			return new SignSubjAltNames(params, policy, attributes);
	}
}
