package com.anf.ws.ar.xml.service.params;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.bouncycastle.asn1.x509.qualified.QCStatement;

import com.anf.cryptotoken.oid.QcStatementsUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class PSD2Params {

	private String idNCA;

	private String nameNCA;
	
	private String authNumber;	
	
	private String countryCode;	

	private List<String> roles;	
	
	public PSD2Params() {
	}
	
	public PSD2Params(String idNCA, String nameNCA, String authNumber, String countryCode, String... roles) {
		this(idNCA, nameNCA, authNumber, countryCode, List.of(roles));
	}

	public PSD2Params(String idNCA, String nameNCA, String authNumber, String countryCode, List<String> roles) {
		super();
		this.idNCA = idNCA;
		this.nameNCA = nameNCA;
		this.authNumber = authNumber;
		this.countryCode = countryCode;
		this.roles = roles;
	}

	public String getIdNCA() {
		return idNCA;
	}

	public void setIdNCA(String idNCA) {
		this.idNCA = idNCA;
	}

	public String getNameNCA() {
		return nameNCA;
	}

	public void setNameNCA(String nameNCA) {
		this.nameNCA = nameNCA;
	}

	public String getAuthNumber() {
		return authNumber;
	}

	public void setAuthNumber(String authNumber) {
		this.authNumber = authNumber;
	}

	public String getCountryCode() {
		return countryCode;
	}

	public void setCountryCode(String countryCode) {
		this.countryCode = countryCode;
	}

	public List<String> getRoles() {
		if(roles==null)
			roles=new ArrayList<String>();
		return roles;
	}

	public void setRoles(List<String> roles) {
		this.roles = roles;
	}
	
	public String buildOrgField() {
		return "PSD"+countryCode+"-"+idNCA+"-"+authNumber;
	}
	
	@JsonIgnore
	public QCStatement getQcStatementsPSD2() {
		if(roles==null)
			roles=new ArrayList<>();
		
		if(nameNCA==null)
			throw new RuntimeException("ERR_PSD2_NAME_NCA_NULL");

		if(countryCode==null)
			throw new RuntimeException("ERR_PSD2_COUNTRY_NULL");
		
		if(idNCA==null)
			throw new RuntimeException("ERR_PSD2_IDNCA_NULL");
		
		Map<String, String> rolesMap=new TreeMap<>();
		roles.forEach(role->{
			rolesMap.put(role.replace("PSP_", ""), role);
		});
		
		return QcStatementsUtils.getQcPSD2(rolesMap, nameNCA, countryCode, idNCA);
	}
}
