package com.anf.ws.ar.xml.qcstatements.impl;

import com.anf.ws.ar.enums.CertificateModality;
import com.anf.ws.ar.xml.model.QcStatements;
import com.anf.ws.ar.xml.qcstatements.QcStatementsProfile;
import com.anf.ws.ar.xml.types.CertificateType;

public class QcStatementsProfileImpl implements QcStatementsProfile{

	private CertificateType certType;

	public QcStatementsProfileImpl(CertificateType certType) {
		this.certType=certType;
	}

	public QcStatements build(CertificateModality modality,Boolean qscd) {
		QcStatements qc = new QcStatements();
		qc.setCompliance("true");
		qc.setSscd(""+(qscd!=null?qscd.booleanValue():modality==CertificateModality.CENTRALIZED || modality==CertificateModality.QSCD));
		if(certType.isSeal())
			qc.setRetentionPeriod("15");
//		qc.setMoney("EUR");
//		qc.setQcBase("1");
//		qc.setQcExp("3");
		return qc;
	}
}
