package com.anf.ws.ar.xml.policy.impl;

import com.anf.ws.ar.enums.ProfileType;
import com.anf.ws.ar.enums.TypeCert;
import com.anf.ws.ar.xml.model.PolicyInfo;
import com.anf.ws.ar.xml.types.CertificateType;

public class EcuadorPoliciesProfile extends StandardPoliciesProfile{

	public EcuadorPoliciesProfile(CertificateType type, String specificOid, String qcpOid) {
		super(type, specificOid, qcpOid);
	}
	
	@Override
	protected PolicyInfo mainPolicy(TypeCert typeCert, String mainPolicyOid, ProfileType policyType) {
		PolicyInfo mainPolicy = super.mainPolicy(typeCert, mainPolicyOid, policyType);
		mainPolicy.setUrl("https://anf.es/ec/repositorio-legal/");		
			
		String userNoticeCertType=userNoticeCertType();
		StringBuilder sb=new StringBuilder();
		sb.append("CERTIFICADO DE ").append(userNoticeCertType);
		if(policyType==ProfileType.QSCD || policyType==ProfileType.Centralized)
			sb.append(" EN DISPOSITIVO SEGURO DE CREACIÓN DE FIRMA - DSCF");
		else
			sb.append(" EN ARCHIVO");
		mainPolicy.setUserNotice(sb.toString());
		return mainPolicy;
	}
	
	private String userNoticeCertType() {
		switch (type) {
		case PERSONA_NATURAL_EC: return "PERSONA NATURAL";
		case MIEMBRO_EMPRESA_EC: return "";
		case REP_LEGAL_EC: return "";
		case SELLO_ELECTRONICO_EC: return "";
		default:
			return type.name();
		}
			
	}

	
}
