package com.anf.ws.ar.xml.policy;

import java.util.ResourceBundle;

import com.anf.ws.ar.enums.TypeCert;
import com.anf.ws.ar.xml.model.PolicyInfo;

public class PolicyInfoBuilder {
	
	private static String url,userNotice;
	
	static {
		ResourceBundle bundle=ResourceBundle.getBundle("com.anf.ws.ar.xml.policy.text.policy");
		url=bundle.getString("url");
		userNotice=bundle.getString("user.notice");
	}

	public static PolicyInfo build(TypeCert typeCert,String policyOid) {		
		return build(typeCert, policyOid, false);
	}
	
	public static PolicyInfo build(TypeCert typeCert,String policyOid,boolean oidOnly) {		
		PolicyInfo politica = new PolicyInfo(typeCert,policyOid);
		if (!oidOnly) {
			politica.setUrl(url);
			politica.setUserNotice(userNotice);
		}
		return politica;
	}
}
