package com.anf.ws.ar.xml.policy;

import com.anf.cryptotoken.oid.PolicyOID;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.ws.ar.enums.ProfileType;
import com.anf.ws.ar.xml.types.CertificateType;

public class CertTypePolicyGenerator {

	public static String getPolicy(PolicyOID policy, CertificateType type, ProfileType policyType) {

		switch (type) {

		case PERSONA_NATURAL_EC:
			switch (policyType) {
			case Centralized, QSCD:
				return policy.oid(ProfilePolicy.PN_DSCF);
			case KeyDist, Software:
				return policy.oid(ProfilePolicy.PN_Archivo);
			default:
				return null;
			}

		case REP_LEGAL_EC:
			switch (policyType) {
			case Centralized, QSCD:
				return policy.oid(ProfilePolicy.RL_DSCF);
			case KeyDist, Software:
				return policy.oid(ProfilePolicy.RL_Archivo);
			default:
				return null;
			}

		case MIEMBRO_EMPRESA_EC:
			switch (policyType) {
			case Centralized, QSCD:
				return policy.oid(ProfilePolicy.ME_ERD_DSCF);
			case KeyDist, Software:
				return policy.oid(ProfilePolicy.ME_ERD_Archivo);
			default:
				return null;
			}

		case SELLO_ELECTRONICO_EC:
			switch (policyType) {
			case Centralized, QSCD:
				return policy.oid(ProfilePolicy.QSEAL_DSCF);
			case KeyDist, Software:
				return policy.oid(ProfilePolicy.QSEAL_Archivo);
			default:
				return null;
			}

		case PERSONA_FISICA:
			switch (policyType) {
			case Centralized:
				return policy.oid(ProfilePolicy.PF_Firma_Centralizado);
			case QSCD:
				return policy.oid(ProfilePolicy.PF_Firma_QSCD);
			case KeyDist, Software:
				return policy.oid(ProfilePolicy.PF_Firma);
			case Auth:
				return policy.oid(ProfilePolicy.PF_Auth);
			case Cipher:
				return policy.oid(ProfilePolicy.PF_Cifrado);
			default:
				return null;
			}
		case PERSONA_FISICA_CORP:
			switch (policyType) {
			case Centralized:
				return policy.oid(ProfilePolicy.PFC_Firma_Centralizado);
			case QSCD:
				return policy.oid(ProfilePolicy.PFC_Firma_QSCD);
			case KeyDist, Software:
				return policy.oid(ProfilePolicy.PFC_Firma);
			default:
				return null;
			}
		case CORPORATIVO_COLEGIADO:
			switch (policyType) {
			case Centralized:
				return policy.oid(ProfilePolicy.CC_Firma_Centralizado);
			case QSCD:
				return policy.oid(ProfilePolicy.CC_Firma_QSCD);
			case KeyDist, Software:
				return policy.oid(ProfilePolicy.CC_Firma);
			default:
				return null;
			}
		case OPERADOR_AR:
		case OPERADOR_AR_2:
			return policy.oid(ProfilePolicy.AR_Firma);
		case RDE:
			return policy.oid(ProfilePolicy.RDE_Firma);
		case REP_LEGAL_PJ:
			switch (policyType) {
			case Centralized:
				return policy.oid(ProfilePolicy.RL_PJ_Firma_Centralizado);
			case QSCD:
				return policy.oid(ProfilePolicy.RL_PJ_Firma_QSCD);
			case KeyDist, Software:
				return policy.oid(ProfilePolicy.RL_PJ_Firma);
			case Auth:
				return policy.oid(ProfilePolicy.RL_PJ_Auth);
			case Cipher:
				return policy.oid(ProfilePolicy.RL_PJ_Cifrado);
			default:
				return null;
			}
		case REP_LEGAL_SIN_PJ:
			switch (policyType) {
			case Centralized:
				return policy.oid(ProfilePolicy.RL_SPJ_Firma_Centralizado);
			case QSCD:
				return policy.oid(ProfilePolicy.RL_SPJ_Firma_QSCD);
			case KeyDist, Software:
				return policy.oid(ProfilePolicy.RL_SPJ_Firma);
			case Auth:
				return policy.oid(ProfilePolicy.RL_SPJ_Auth);
			case Cipher:
				return policy.oid(ProfilePolicy.RL_SPJ_Cifrado);
			default:
				return null;
			}
		case REP_LEGAL_ADMIN_UNICOS:
			switch (policyType) {
			case Centralized:
				return policy.oid(ProfilePolicy.RL_AU_Firma_Centralizado);
			case QSCD:
				return policy.oid(ProfilePolicy.RL_AU_Firma_QSCD);
			case KeyDist, Software:
				return policy.oid(ProfilePolicy.RL_AU_Firma);
			case Auth:
				return policy.oid(ProfilePolicy.RL_AU_Auth);
			case Cipher:
				return policy.oid(ProfilePolicy.RL_AU_Cifrado);
			default:
				return null;
			}
		case EMPLEADO_PUBLICO_ALTO:
			return policy.oid(ProfilePolicy.EP_Alto_Firma);
		case EMPLEADO_PUBLICO_MEDIO:
			return policy.oid(ProfilePolicy.EP_Medio_Firma);
		case OPERADOR_PKI_ADMIN:
			return policy.oid(ProfilePolicy.PKI_ADMIN_Firma);
		case OPERADOR_PKI:
			return policy.oid(ProfilePolicy.PKI_Firma);
		case QSEALC:
			switch (policyType) {
			case Centralized:
				return policy.oid(ProfilePolicy.QSeal_Centralizado);
			case QSCD:
				return policy.oid(ProfilePolicy.QSeal_QSCD);
			case KeyDist:
				return policy.oid(ProfilePolicy.QSeal_DistClaves);
			case Software:
				return policy.oid(ProfilePolicy.QSeal_Software);
			default:
				return null;
			}
		case QSEALC_AP_MEDIO:
			switch (policyType) {
			case KeyDist:
				return policy.oid(ProfilePolicy.QSeal_AP_DistClaves);
			case Software:
				return policy.oid(ProfilePolicy.QSeal_AP_Software);
			default:
				return null;
			}
		case QSEALC_AP_ALTO:
			switch (policyType) {
			case Centralized:
				return policy.oid(ProfilePolicy.QSeal_AP_Centralizado);
			case QSCD:
				return policy.oid(ProfilePolicy.QSeal_AP_QSCD);
			default:
				return null;
			}
		case QSEALC_PSD2:
			switch (policyType) {
			case Centralized:
				return policy.oid(ProfilePolicy.QSeal_PSD2_Centralizado);
			case QSCD:
				return policy.oid(ProfilePolicy.QSeal_PSD2_QSCD);
			case KeyDist:
				return policy.oid(ProfilePolicy.QSeal_PSD2_DistClaves);
			case Software:
				return policy.oid(ProfilePolicy.QSeal_PSD2_Software);
			default:
				return null;
			}
		default:
			return null;
		}
	}

}
