package com.anf.ws.ar.xml.parser.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import com.anf.ws.ar.xml.utils.XmlUtils;

public class ARParser {
	
	private Map<String,String> subjectAttributes;
	private Map<String,String> extensions;

	public ARParser(InputStream input) throws ParserConfigurationException, SAXException, IOException {
		this(XmlUtils.readDOMDocument(input));
	}

	public ARParser(Document registrationXML) {
		this.subjectAttributes = new HashMap<>();
		this.extensions = new HashMap<>();
		this._$526(registrationXML);
		this._$527(registrationXML);
	}

	public Map<String,String> getSubjectAttributes() {
		return new HashMap<String,String>(this.subjectAttributes);
	}

	public Map<String,String> getExtensions() {
		return new HashMap<>(this.extensions);
	}

	private void _$526(Document registrationXML) {
		this._$530(registrationXML, "Attributes", "Attribute", "AttributeType", "AttributeValue", this.subjectAttributes);
	}

	private void _$527(Document registrationXML) {
		this._$530(registrationXML, "Extensions", "Extension", "ExtensionOID", "ExtensionValue", this.extensions);
	}

	private void _$530(Document registrationXML, String firstLevelTag, String secondLevelTag, String typeTag,
			String valueTag, Map<String,String> registrationMap) {
		Node root = registrationXML.getFirstChild();
		Node applicantNode = XmlUtils.getChildNodeWithName(root, "Applicant");
		Node attributesNode = XmlUtils.getChildNodeWithName(applicantNode, firstLevelTag);
		if (attributesNode != null) {
			NodeList attsNodes = attributesNode.getChildNodes();

			for (int i = 0; i < attsNodes.getLength(); ++i) {
				Node currentChild = attsNodes.item(i);
				if (secondLevelTag.equals(currentChild.getNodeName())) {
					Node typeNode = XmlUtils.getChildNodeWithName(currentChild, typeTag);
					Node valueNode = XmlUtils.getChildNodeWithName(currentChild, valueTag);
					if (typeNode!=null && valueNode!=null && typeNode.getFirstChild()!=null && valueNode.getFirstChild()!=null) {
						String oid = typeNode.getFirstChild().getNodeValue();
						String value = valueNode.getFirstChild().getNodeValue();
						if(oid!=null)
							registrationMap.put(oid, value);
					}
				}
			}
		}

	}
}