package com.anf.ws.ar.xml.kusages;

import com.anf.ws.ar.xml.kusages.impl.ARKeyUsagesProfile;
import com.anf.ws.ar.xml.kusages.impl.EmpleadoPublicoKeyUsagesProfile;
import com.anf.ws.ar.xml.kusages.impl.OperadorPKIKeyUsagesProfile;
import com.anf.ws.ar.xml.kusages.impl.PerfilesECKeyUsagesProfile;
import com.anf.ws.ar.xml.kusages.impl.PersonaFisicaCorpKeyUsagesProfile;
import com.anf.ws.ar.xml.kusages.impl.PersonaFisicaKeyUsagesProfile;
import com.anf.ws.ar.xml.kusages.impl.QSealKeyUsagesProfile;
import com.anf.ws.ar.xml.kusages.impl.RDEKeyUsagesProfile;
import com.anf.ws.ar.xml.kusages.impl.RepLegalAdminKeyUsagesProfile;
import com.anf.ws.ar.xml.kusages.impl.RepLegalPJKeyUsagesProfile;
import com.anf.ws.ar.xml.kusages.impl.RepLegalSinPJKeyUsagesProfile;
import com.anf.ws.ar.xml.types.CertificateType;

public class KeyUsagesProfileFactory {

	public static KeyUsagesProfile getKeyUsages(CertificateType type) {

		switch (type) {
		case PERSONA_NATURAL_EC,REP_LEGAL_EC,SELLO_ELECTRONICO_EC,MIEMBRO_EMPRESA_EC: return new PerfilesECKeyUsagesProfile();
		case PERSONA_FISICA:return new PersonaFisicaKeyUsagesProfile();
		case PERSONA_FISICA_CORP,CORPORATIVO_COLEGIADO:return new PersonaFisicaCorpKeyUsagesProfile();		
		case OPERADOR_AR, OPERADOR_AR_2: return new ARKeyUsagesProfile();
		case RDE: return new RDEKeyUsagesProfile();
		case REP_LEGAL_PJ: return new RepLegalPJKeyUsagesProfile();
		case REP_LEGAL_SIN_PJ: return new RepLegalSinPJKeyUsagesProfile();
		case REP_LEGAL_ADMIN_UNICOS: return new RepLegalAdminKeyUsagesProfile();
		case EMPLEADO_PUBLICO_ALTO, EMPLEADO_PUBLICO_MEDIO: return new EmpleadoPublicoKeyUsagesProfile();
		case OPERADOR_PKI_ADMIN, OPERADOR_PKI: return new OperadorPKIKeyUsagesProfile();
		case QSEALC, QSEALC_AP_MEDIO, QSEALC_AP_ALTO, QSEALC_PSD2: return new QSealKeyUsagesProfile();
			
		default:
			return null;
		}
	}
}
