package com.anf.ws.ar.xml.key.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;

import com.anf.ws.ar.xml.key.KeyProfile;
import com.anf.ws.ar.xml.model.Key;

public class KeyProfileImpl implements KeyProfile{

	private static final Logger log = LogManager.getLogger(KeyProfileImpl.class);

	private static final String DEFAULT_ALGORITHM = "SHA256WithRSAEncryption";
	
	public Key build(String signAlg,int keySize) {
		if(keySize<2048 || keySize%512!=0) {
			log.info("using default key size 2048 because request has invalid key size: {}",keySize);
			keySize=2048;
		}
		
		if(signAlg==null || signAlg.isBlank() || !validAlgorithm(signAlg))
			signAlg=DEFAULT_ALGORITHM;
		
		Key key = new Key();
		key.setAlgorithm(signAlg);
		key.setKeyLength(String.valueOf(keySize));
		return key;
	}

	private boolean validAlgorithm(String signAlg) {
		return new DefaultSignatureAlgorithmIdentifierFinder().find(signAlg)!=null;
	}
}
