package com.anf.ws.ar.xml.io;

import java.io.ByteArrayOutputStream;
import java.io.File;

import com.anf.ra.xml.ApplicationForm;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;

public interface XmlWriter {
	

	public static void writeXml(ApplicationForm appForm,File output) throws JAXBException {
		/**
		 * Se genera el archivo XML en base al objeto raíz ApplicationForm.
		 */
		JAXBContext jaxbContext = JAXBContext.newInstance(ApplicationForm.class);
		Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
		jaxbMarshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);		
		jaxbMarshaller.marshal(appForm, output);
	}

	public static byte[] writeXml(ApplicationForm appForm) throws JAXBException {
		/**
		 * Se genera el archivo XML en base al objeto raíz ApplicationForm.
		 */
		JAXBContext jaxbContext = JAXBContext.newInstance(ApplicationForm.class);
		Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
		jaxbMarshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);	
		ByteArrayOutputStream out=new ByteArrayOutputStream();
		jaxbMarshaller.marshal(appForm, out);
		return out.toByteArray();
	}
}
