package com.anf.ws.ar.xml.ekusages.impl;

import java.util.ArrayList;
import java.util.List;

import com.anf.ws.ar.enums.ProfileType;
import com.anf.ws.ar.xml.ekusages.ExtKeyUsagesProfile;
import com.anf.ws.ar.xml.model.ExtendedKeyUsage;
import com.anf.ws.ar.xml.types.CertificateType;
import com.anf.ws.ar.xml.types.TypeCertConverter;

public class StandardExtendedKeyUsagesProfile extends TypeCertConverter implements ExtKeyUsagesProfile{
	
	public StandardExtendedKeyUsagesProfile(CertificateType type) {
		super(type);
	}


	@Override
	public List<ExtendedKeyUsage> getExtKeyUsages(ProfileType profileType, List<String> ekus) {
		List<ExtendedKeyUsage> usages = new ArrayList<>();
		if(ekus==null)
			ekus=new ArrayList<>();
		if(ekus.isEmpty())
			ekus.addAll(List.of("autentificacion cliente","cifrado correo"));
		usages.add(new ExtendedKeyUsage(convertType(profileType), ekus));
		return usages;
	}

}
