package com.anf.ws.ar.xml.builder;

import java.util.List;

import com.anf.ra.xml.ApplicationForm;
import com.anf.ra.xml.ApplicationForm.Applicant;
import com.anf.ra.xml.ObjectFactory;
import com.anf.ws.ar.xml.model.SubjectDirectory;

public class XmlSubjDirAttributesBuilder {

	private ObjectFactory xmlFactory;
	
	private Applicant applicant;
	
	public XmlSubjDirAttributesBuilder(ObjectFactory xmlFactory, Applicant applicant) {
		this.xmlFactory=xmlFactory;
		this.applicant=applicant;
	}

	
	public void setSubjDirAttributes(List<SubjectDirectory> subjecDirectories) {
		/**
		 * Se inserta la informacion correspondiente al nodo
		 * SubjectDirectoryAtributes.
		 */
		if (subjecDirectories != null && !subjecDirectories.isEmpty()) {
			ApplicationForm.Applicant.SubjectDirectoryAtributes subjectDirectoryAtributes = xmlFactory.createApplicationFormApplicantSubjectDirectoryAtributes();
			for (SubjectDirectory s : subjecDirectories) {
				ApplicationForm.Applicant.SubjectDirectoryAtributes.SubjectDirectoryAtribute subjectDirectoryAtribute = xmlFactory.createApplicationFormApplicantSubjectDirectoryAtributesSubjectDirectoryAtribute();
				subjectDirectoryAtribute.setDirectoryOID(s.getDirectoryOid());
				subjectDirectoryAtribute.setDirectoryValue(s.getDirectoryValue());
				subjectDirectoryAtributes.getSubjectDirectoryAtribute().add(subjectDirectoryAtribute);
			}
			applicant.setSubjectDirectoryAtributes(subjectDirectoryAtributes);
		}
	}
}
