package com.anf.ws.ar.xml.builder;

import java.util.ArrayList;
import java.util.List;

import com.anf.ra.xml.ApplicationForm;
import com.anf.ra.xml.ApplicationForm.Applicant;
import com.anf.ra.xml.ObjectFactory;
import com.anf.ws.ar.xml.model.SubjectAlternateName;

public class XmlSubjAltNamesBuilder {

	private ObjectFactory xmlFactory;
	
	private Applicant applicant;
	
	public XmlSubjAltNamesBuilder(ObjectFactory xmlFactory, Applicant applicant) {
		this.xmlFactory=xmlFactory;
		this.applicant=applicant;
	}

	
	public void setSubjAltNames(List<SubjectAlternateName> list) {
		/**
		 * Se inserta la informacion correspondiente al nodo
		 * SubjectAlternateNames.
		 */
		ApplicationForm.Applicant.SubjectAlternateNames subjectAlternateNames = xmlFactory.createApplicationFormApplicantSubjectAlternateNames();
		List<com.anf.ra.xml.ApplicationForm.Applicant.SubjectAlternateNames.SubjectAlternateName> subjAltNames=new ArrayList<ApplicationForm.Applicant.SubjectAlternateNames.SubjectAlternateName>();
		subjectAlternateNames.setSubjectAlternateName(subjAltNames);
		for (SubjectAlternateName subjectAlternateName : list) {
			com.anf.ra.xml.ApplicationForm.Applicant.SubjectAlternateNames.SubjectAlternateName subjAltName = xmlFactory.createApplicationFormApplicantSubjectAlternateNamesSubjectAlternateName();
			subjAltName.setRfc822Name(subjectAlternateName.getRfc());
			subjAltName.setAlterNameOID(subjectAlternateName.getOid());
			subjAltName.setAlterNameOIDValue(subjectAlternateName.getValue());
			subjAltNames.add(subjAltName);
		}
		applicant.setSubjectAlternateNames(subjectAlternateNames);
	}
}
