package com.anf.ws.ar.xml.builder;

import com.anf.ra.xml.ApplicationForm;
import com.anf.ra.xml.ApplicationForm.Applicant;
import com.anf.ra.xml.ApplicationForm.Applicant.QcStatements.QcPSD2;
import com.anf.ra.xml.ObjectFactory;
import com.anf.ws.ar.xml.model.QcStatements;
import com.anf.ws.ar.xml.service.params.PSD2Params;

public class XmlQcStatementsBuilder {

	private ObjectFactory xmlFactory;
		
	private Applicant applicant;
	
	public XmlQcStatementsBuilder(ObjectFactory xmlFactory, Applicant applicant) {
		this.xmlFactory=xmlFactory;
		this.applicant=applicant;
	}

	public void setQcStatements(QcStatements qc) {
		/**
		 * Se inserta la informacion correspondiente al nodo QcStatements.
		 */
		if (qc != null) {
			ApplicationForm.Applicant.QcStatements qcStatements = xmlFactory.createApplicationFormApplicantQcStatements();
			qcStatements.setQcCompliance(qc.getCompliance());
			if(qc.getRetentionPeriod()!=null)
				qcStatements.setQcRetentionPeriod(Byte.valueOf(qc.getRetentionPeriod()));
			qcStatements.setQcSSCD(qc.getSscd());
			PSD2Params requestPsd2 = qc.getPsd2();
			if (requestPsd2!=null) {
				QcPSD2 psd2 = new QcPSD2();
				psd2.setAuthNumber(requestPsd2.getAuthNumber());
				psd2.setCountryCode(requestPsd2.getCountryCode());
				psd2.setIdNCA(requestPsd2.getIdNCA());
				psd2.setNameNCA(requestPsd2.getNameNCA());
				psd2.setRoles(requestPsd2.getRoles());
				qcStatements.setQcPSD2(psd2);
			}
			//			ApplicationForm.Applicant.QcStatements.QcLimitValue qcLimitValue = xmlFactory.createApplicationFormApplicantQcStatementsQcLimitValue();
//			qcLimitValue.setMoney(qc.getMoney());
//			qcLimitValue.setQcBase(Byte.valueOf(qc.getQcBase()));
//			qcLimitValue.setQcExp(Byte.valueOf(qc.getQcExp()));
//			qcStatements.setQcLimitValue(qcLimitValue);
			applicant.setQcStatements(qcStatements);
		}
	}
}
