package com.anf.ws.ar.xml.builder;

import java.util.List;

import com.anf.ra.xml.ApplicationForm;
import com.anf.ra.xml.ApplicationForm.Applicant;
import com.anf.ra.xml.ObjectFactory;
import com.anf.ws.ar.xml.model.PolicyInfo;

public class XmlPoliciesBuilder {

	private ObjectFactory xmlFactory;
	private ApplicationForm appForm;
	private Applicant applicant;
	
	
	public XmlPoliciesBuilder(ObjectFactory xmlFactory, ApplicationForm appForm, Applicant applicant) {
		this.xmlFactory=xmlFactory;
		this.appForm=appForm;		
		this.applicant=applicant;
	}

	public void setPolicies(List<PolicyInfo> politicas) {

		/**
		 * Se inserta la informacion correspondiente al nodo policyinfos.
		 */
		if (politicas != null && !politicas.isEmpty()) {
			ApplicationForm.Applicant.Policyinfos policyinfos = xmlFactory.createApplicationFormApplicantPolicyinfos();
			for (PolicyInfo p : politicas) {
				ApplicationForm.Applicant.Policyinfos.PolicyInfo policyInfo = xmlFactory.createApplicationFormApplicantPolicyinfosPolicyInfo();
				policyInfo.setOid(p.getOid());
				policyInfo.setTypecert(p.getTypeCert());
				policyInfo.setUrl(p.getUrl());
				policyInfo.setUsernotice(p.getUserNotice());
				policyinfos.getPolicyInfo().add(policyInfo);
			}
			applicant.setPolicyinfos(policyinfos);
			// politicas = eliminarARepetidos(politicas);

			Byte inactiveByte = Byte.valueOf("0");
			appForm.setQualified(inactiveByte);
			appForm.setExportable(inactiveByte);
			appForm.setCatcertn4(inactiveByte);
			appForm.setPfisfirma(inactiveByte);
			appForm.setPfiscifrado(inactiveByte);
			appForm.setPfisaut(inactiveByte);
			appForm.setPjuridicafirma(inactiveByte);
			appForm.setPjuridicaaut(inactiveByte);
			appForm.setEntaut(inactiveByte);
			appForm.setEntfirma(inactiveByte);
			appForm.setEntcifrado(inactiveByte);
			appForm.setColaut(inactiveByte);
			appForm.setColfirma(inactiveByte);
			appForm.setColcifrado(inactiveByte);
			appForm.setAplication(inactiveByte);
			appForm.setFirmacodigo(inactiveByte);
			appForm.setCifrado(inactiveByte);
			appForm.setOrgano(inactiveByte);
			appForm.setSellomedio(inactiveByte);
			appForm.setSelloalto(inactiveByte);
			appForm.setSslev(inactiveByte);
			appForm.setAr(inactiveByte);
			appForm.setRde(inactiveByte);
			appForm.setOperador(inactiveByte);
			appForm.setPublicofirmaalto(inactiveByte);
			appForm.setPublicofirmamedio(inactiveByte);
			appForm.setPublicoautalto(inactiveByte);
			appForm.setPublicoautmedio(inactiveByte);
			appForm.setPublicocifradoalto(inactiveByte);
			appForm.setPublicocifradomedio(inactiveByte);
			appForm.setSsl(inactiveByte);
			appForm.setSedemedio(inactiveByte);
			appForm.setSedealto(inactiveByte);
			appForm.setSedemedioev(inactiveByte);
			appForm.setSedealtoev(inactiveByte);
			appForm.setReplegalpjfirma(inactiveByte);
			appForm.setReplegalpjcifrado(inactiveByte);
			appForm.setReplegalpjaut(inactiveByte);
			appForm.setReplegalentsinpjfirma(inactiveByte);
			appForm.setReplegalentsinpjcifrado(inactiveByte);
			appForm.setReplegalentsinpjaut(inactiveByte);
			appForm.setSelloelecaappnivalto(inactiveByte);
			appForm.setSelloelecaappnivmedio(inactiveByte);
			appForm.setReplegaladminfirma(inactiveByte);
			appForm.setReplegaladmincifrado(inactiveByte);
			appForm.setReplegaladminaut(inactiveByte);
			/**
			 * En base a las políticas que posea la solicitud, se asigna el
			 * valor de "1" al atributo correspondiente a la política.
			 */
			Byte activeByte = Byte.valueOf("1");
			for (PolicyInfo p : politicas) {
				switch (p.getTypeCert()) {
				case "qualified":
					appForm.setQualified(activeByte);
					break;
				case "exportable":
					appForm.setExportable(activeByte);
					break;
				case "catcertn4":
					appForm.setCatcertn4(activeByte);
					break;
				case "pfisfirma":
					appForm.setPfisfirma(activeByte);
					break;
				case "pfiscifrado":
					appForm.setPfiscifrado(activeByte);
					break;
				case "pfisaut":
					appForm.setPfisaut(activeByte);
					break;
				case "pjuridicafirma":
					appForm.setPjuridicafirma(activeByte);
					break;
				case "pjuridicacifrado":
					appForm.setPjuridicacifrado(activeByte);
					break;
				case "pjuridicaaut":
					appForm.setPjuridicaaut(activeByte);
					break;
				case "entfirma":
					appForm.setEntfirma(activeByte);
					break;
				case "entcifrado":
					appForm.setEntcifrado(activeByte);
					break;
				case "colaut":
					appForm.setColaut(activeByte);
					break;
				case "colfirma":
					appForm.setColfirma(activeByte);
					break;
				case "colcifrado":
					appForm.setColcifrado(activeByte);
					break;
				case "aplication":
					appForm.setAplication(activeByte);
					break;
				case "firmacodigo":
					appForm.setFirmacodigo(activeByte);
					break;
				case "cifrado":
					appForm.setCifrado(activeByte);
					break;
				case "organo":
					appForm.setOrgano(activeByte);
					break;
				case "sellomedio":
					appForm.setSellomedio(activeByte);
					break;
				case "selloalto":
					appForm.setSelloalto(activeByte);
					break;
				case "sslev":
					appForm.setSslev(activeByte);
					break;
				case "ar":
					appForm.setAr(activeByte);
					break;
				case "rde":
					appForm.setRde(activeByte);
					break;
				case "operador":
					appForm.setOperador(activeByte);
					break;
				case "publicofirmaalto":
					appForm.setPublicofirmaalto(activeByte);
					break;
				case "publicofirmamedio":
					appForm.setPublicofirmamedio(activeByte);
					break;
				case "publicoautalto":
					appForm.setPublicoautalto(activeByte);
					break;
				case "publicoautmedio":
					appForm.setPublicoautmedio(activeByte);
					break;
				case "publicocifradoalto":
					appForm.setPublicocifradoalto(activeByte);
					break;
				case "publicocifradomedio":
					appForm.setPublicocifradomedio(activeByte);
					break;
				case "ssl":
					appForm.setSsl(activeByte);
					break;
				case "sedemedio":
					appForm.setSedemedio(activeByte);
					break;
				case "sedealto":
					appForm.setSedealto(activeByte);
					break;
				case "sedemedioev":
					appForm.setSedemedioev(activeByte);
					break;
				case "sedealtoev":
					appForm.setSedealtoev(activeByte);
					break;
				case "replegalpjfirma":
					appForm.setReplegalpjfirma(activeByte);
					break;
				case "replegalpjcifrado":
					appForm.setReplegalpjcifrado(activeByte);
					break;
				case "replegalpjaut":
					appForm.setReplegalpjaut(activeByte);
					break;
				case "replegalentsinpjfirma":
					appForm.setReplegalentsinpjfirma(activeByte);
					break;
				case "replegalentsinpjcifrado":
					appForm.setReplegalentsinpjcifrado(activeByte);
					break;
				case "replegalentsinpjaut":
					appForm.setReplegalentsinpjaut(activeByte);
					break;
				case "selloelecaappnivalto":
					appForm.setSelloelecaappnivalto(activeByte);
					break;
				case "selloelecaappnivmedio":
					appForm.setSelloelecaappnivmedio(activeByte);
					break;
				case "replegaladminfirma":
					appForm.setReplegaladminfirma(activeByte);
					break;
				case "replegaladmincifrado":
					appForm.setReplegaladmincifrado(activeByte);
					break;
				case "replegaladminaut":
					appForm.setReplegaladminaut(activeByte);
					break;
				}
			}
		}
	}
}
