package com.anf.ws.ar.xml.builder;

import com.anf.ra.xml.ApplicationForm;
import com.anf.ra.xml.ApplicationForm.Applicant;
import com.anf.ra.xml.ObjectFactory;
import com.anf.ws.ar.xml.model.Key;

public class XmlKeyBuilder {

	private ObjectFactory xmlFactory;
	
	private Applicant applicant;
	
	public XmlKeyBuilder(ObjectFactory xmlFactory, Applicant applicant) {
		this.xmlFactory=xmlFactory;
		this.applicant=applicant;
	}

	
	public void setKey(Key clave) {
		/**
		 * Se inserta la informacion correspondiente al nodo key.
		 */
		if (clave != null) {
			ApplicationForm.Applicant.Key key = xmlFactory.createApplicationFormApplicantKey();
			key.setAlgorithm(clave.getAlgorithm());
			key.setKeyLength(Short.valueOf(clave.getKeyLength()));
			applicant.setKey(key);
		}
	}
}
