package com.anf.ws.ar.xml.attributes;

import com.anf.ws.ar.xml.attributes.impl.QSealAttributesProfile;
import com.anf.ws.ar.xml.attributes.impl.SignAttributesProfile;
import com.anf.ws.ar.xml.service.params.XmlBuildParams;
import com.anf.ws.ar.xml.types.CertificateType;

public interface AttributesProfileFactory {

	public static AttributesProfile getAttributes(XmlBuildParams params, CertificateType certType) {

		if(certType.isSeal())
			return new QSealAttributesProfile(params, certType);
		
		return new SignAttributesProfile(params, certType);

	}
}
