package com.anf.ws.ar.xml.attributes;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.style.BCStyle;

import com.anf.ra.xml.ApplicationForm;
import com.anf.ra.xml.ApplicationForm.Applicant.Attributes;
import com.anf.ra.xml.ApplicationForm.Applicant.Attributes.Attribute;
import com.anf.ws.ar.xml.exception.XmlAttributeException;
import com.anf.ws.ar.xml.types.CertificateType;

public class AttributeValidator {
	
	private static Set<String> otherValidAttributes=new TreeSet<>(List.of(
			BCStyle.ORGANIZATION_IDENTIFIER.getId(),
			BCStyle.DESCRIPTION.getId(),
			"1.3.6.1.4.1.18838.1.1",
			"1.3.6.1.4.1.37442.10.4"));

	private  AttributeValidator() {}

	public static void validateAttributes(Attributes attributes) {
		List<Attribute> attributeList = attributes.getAttribute();
		
		validateAttributes(attributeList);
	}


	public static void validateAttributes(List<Attribute> attributeList) {
		for (Attribute attribute : attributeList) {
			String oid = attribute.getAttributeType();
			if(!otherValidAttributes.contains(oid) && BCStyle.INSTANCE.oidToDisplayName(new ASN1ObjectIdentifier(oid))==null)
				throw new XmlAttributeException("ERR_INVALID_OID:"+oid);
		}
	}
	

	public static boolean validAttribute(CertificateType certType, String country, ApplicationForm.Applicant.Attributes.Attribute attribute) {
		boolean nullValue=attribute.getAttributeValue()==null || attribute.getAttributeValue().isEmpty() || attribute.getAttributeValue().equals("undefined");
		if(nullValue)
			return false;

		if(certType.match(CertificateType.PERSONA_FISICA)) {
			return !attribute.getAttributeType().equals(BCStyle.T.getId()) && 
					validLocalityOrState(country, attribute);
		}else if(certType.match(CertificateType.CORPORATIVO_COLEGIADO)) {
			return !attribute.getAttributeType().equals(BCStyle.EmailAddress.getId()) && 
					validLocalityOrState(country, attribute);
		}else if(certType.match(
				CertificateType.REP_LEGAL_PJ,
				CertificateType.REP_LEGAL_SIN_PJ,
				CertificateType.REP_LEGAL_ADMIN_UNICOS)) {
			return validLocalityOrState(country, attribute);
		}else if(certType.match(
				CertificateType.EMPLEADO_PUBLICO_MEDIO,
				CertificateType.EMPLEADO_PUBLICO_ALTO)) {
			return  !attribute.getAttributeType().equals(BCStyle.DESCRIPTION.getId()) && 
					!attribute.getAttributeType().equals(BCStyle.T.getId()) && 
					!attribute.getAttributeType().equals(BCStyle.EmailAddress.getId());
		}else if(certType.isSeal()) {
			return  !attribute.getAttributeType().equals(BCStyle.GIVENNAME.getId()) && 
					!attribute.getAttributeType().equals(BCStyle.SURNAME.getId()) && 
					!attribute.getAttributeType().equals(BCStyle.DESCRIPTION.getId()) && 
					!attribute.getAttributeType().equals(BCStyle.T.getId()) && 
					!attribute.getAttributeType().equals(BCStyle.EmailAddress.getId()) &&
					validLocalityOrState(country, attribute);
			
		}else if(certType.match(
				CertificateType.PERSONA_NATURAL_EC,
				CertificateType.REP_LEGAL_EC)) {
			return !attribute.getAttributeType().equals(BCStyle.OU.getId()) &&
					!attribute.getAttributeType().equals(BCStyle.ST.getId()) &&
					!attribute.getAttributeType().equals(BCStyle.EmailAddress.getId());
		}else if(certType.match(
				CertificateType.PERSONA_NATURAL_EC,
				CertificateType.MIEMBRO_EMPRESA_EC,
				CertificateType.REP_LEGAL_EC,
				CertificateType.SELLO_ELECTRONICO_EC)) {
			return !attribute.getAttributeType().equals(BCStyle.ST.getId()) &&
			!attribute.getAttributeType().equals(BCStyle.EmailAddress.getId());
		}
		return !nullValue;
	}


	private static boolean validLocalityOrState(String country,
			ApplicationForm.Applicant.Attributes.Attribute attribute) {
		return !country.equals("ES") ||
		!attribute.getAttributeType().equals(BCStyle.L.getId()) && 
		!attribute.getAttributeType().equals(BCStyle.ST.getId());
	}
	
}
