package com.anf.ws.ar.services;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SurnameSplitter {

	private String[] separators=new String[]{
			" DE LA ",
			" DE LAS ",
			" DE LO ",
			" DE LOS ",
			" DEL ",
			" DE ",
			" LA ",
			" LAS ",
			" LO ",
			" LOS ",
			" I ",
			" Y "			
	};

	private String[] rules=new String[] {
			"<S> <W> <-> <S> <W>",//la merced de los herrera
			"<W> <-> <S> <W>",//perez de los monteros
			"<W> <-> <W> <S> <W>",//betancourt ponce de leon
			"<S> <W> <-> <W>",//de los monteros perez
			"<W> <S> <W> <-> <W>",//ponce de leon betancourt
			"<W> <S> <W> <-> <S> <W>",//ponce de leon de los herrera
			"<S> <W> <-> <W> <S> <W>",//de los herrera ponce de leon 
			"<W> <-> <S> <S> <W>",//perez de entre rios 
			"<S> <S> <W> <-> <W>",//de entre rios perez 
			"<W> <-> <W>",//perez lopez 
	};

	/**
	 * 
	 * si surname es:
	 * JUAN [ DE LA ] RENTA
	 * entonces lastName1 es JUAN y lastName2 es DE LA RENTA
	 * 
	 * Si surname es:
	 * [ DE LOS ] BOSQUES PEREZ
	 * entonces lastName1 es DE LOS BOSQUES y lastName2 es PEREZ
	 * @param surname
	 * @param lastName1
	 * @param lastName2
	 */
	public String splitSurname(String surname,Consumer<String> lastName1,Consumer<String> lastName2){

		for (String rule : rules) {
			if(match(rule,surname,lastName1,lastName2)) {
				return rule;
			}
		}
		return null;
	}

	private boolean match(String rule, String surname,Consumer<String> lastName1,Consumer<String> lastName2) {
		String transform = replaceSeparators(" "+surname+" ");
		String[] split = transform.split(" ");
		String matchingRule="";
		for (String token : split) {
			if (!token.isEmpty()) {
				if (isSeparator(token))
					token = "<S>";
				else
					token = "<W>";
				matchingRule += token + " ";
			}
		}
		if(matchingRule.trim().equals(rule.replace(" <->", ""))) {
			String[] wordsAll = transform.split(" ");
			List<String> list = Stream.of(wordsAll).filter(w->!w.isEmpty()).collect(Collectors.toList());
			String[] words=new String[list.size()];
			list.toArray(words);
			String[] tokens=rule.split(" ");
			if (words.length==tokens.length-1) {
				StringBuilder value = new StringBuilder();
				int word = 0,tk=0;
				for (; tk < tokens.length; tk++) {
					String token=tokens[tk];
					if (token.equals("<W>")) {
						value.append(words[word++] + " ");
					} else if (token.equals("<S>")) {
						if(isSeparator(words[word])) {
							value.append(words[word].replace("_", " ") + " ");									
						}
						word++;
					} else if (token.equals("<->")) {
						tk++;
						break;
					}
				}
				lastName1.accept(value.toString().trim());
				value = new StringBuilder();
				for (; tk < tokens.length; tk++) {
					String token=tokens[tk];
					if (token.equals("<W>")) {
						value.append(words[word++] + " ");
					} else if (token.equals("<S>")) {
						if(isSeparator(words[word])) {
							value.append(words[word].replace("_", " ") + " ");									
						}
						word++;
					} else if (token.equals("<->")) {
						tk++;
						break;
					}
				}
				lastName2.accept(value.toString().trim());
				return true;
			}

		}

		return false;
	}

	private String replaceSeparators(String surname) {
		String transform=surname;
		for (String subsep : separators) {
			transform=transform.replace(subsep, " "+ subsep.trim().replace(" ", "_")+" ");
		}
		String[] split = transform.split(" ");
		transform=" ";
		for (String word : split) {
			if (!word.isEmpty()) {
				if (isSeparator(word))
					word = word.replace(" ", "_");
				transform += word + " ";
			}
		}
		return transform;
	}

	private boolean isSeparator(String word) {
		if(word.length()<3)
			return true;
		for (String sep : separators) {
			if(sep.trim().replace(" ", "_").equals(word.trim()))
				return true;
		}
		return false;
	}

	public String[] getRules() {
		return rules;
	}

	public String[] getSeparators() {
		return separators;
	}

}
